#include <iostream>
#include <vector>


using namespace std;

vector<vector<bool>> used(2500, vector<bool>(2500));

bool color(int x, int y) {
    cout << "? " << x << " " << y << endl;
    cout.flush();
    char ch;
    cin >> ch;
    return ch == 'B';
}

pair<vector<pair<int, int>>, bool> draw(int x, int y, int n, bool clr) {
    if (n == 0) {
        return {};
    }
    used[1250 + x][1250 + y] = true;
    for (int di = -1; di <= 1; ++di) {
        for (int dj = -1; dj <= 1; ++dj) {
            if (di == 0 && dj == 0 || used[1250 + x + di][1250 + x + dj]) continue;
            if (color(x + di, y + dj) == clr) {
                auto [q, bad] = draw(x + di, y + dj, n - 1, clr);
                if (bad) continue;
                if (q.empty() && n != 1) continue;

                q.push_back({x + di, y + dj});
                return {q, false};
            }
        }
    }
    return {{}, true};
}

int main() {
    int t;
    cin >> t;

    while (t --> 0) {
        int n;
        cin >> n;
        bool c = color(0, 0);
        auto [q, bad] = draw(0, 0, n - 1, c);
        if (bad) cout << "AAAAA";
        q.push_back({0, 0});
        cout << "! " << (c ? 'B' : 'W') << " ";
        for (auto& [i, j] : q) {
            cout << i << " " << j << " ";
        }
        cout.flush();
        used.assign(2500, vector<bool>(2500));
    }
}