#include <iostream>
#include <algorithm>
#include <vector>
#include <map>
using namespace std;

const long long INF = 1000000000ll*1000000000ll;
map<int, long long> memo;
map<int, int> rightmost_key;
map<int, int> leftmost_key;
long long min_time(int pos) {
    if (memo.count(pos)) {
        return memo[pos];
    }
    if (pos < 0 && rightmost_key.count(pos)) {
        int key = rightmost_key[pos];
        if (key > 0) {
            memo[pos] = (long long)key - pos + min_time(key);
        }
        else {
            auto ub = rightmost_key.upper_bound(pos);
            if (ub == rightmost_key.end() || ub->first > 0) {
                memo[pos] = -pos;
            }
            else {
                memo[pos] = (long long)ub->first - pos + min_time(ub->first);
            }
        }
    }
    else if (pos > 0 && leftmost_key.count(pos)) {
        int key = leftmost_key[pos];
        if (key < 0) {
            memo[pos] = (long long)pos - key + min_time(key);
        }
        else {
            auto lb = leftmost_key.lower_bound(pos);
            if (lb == leftmost_key.begin() || prev(lb)->first < 0) {
                memo[pos] = pos;
            }
            else {
                memo[pos] = (long long)pos - prev(lb)->first + min_time(prev(lb)->first);
            }
        }
    }
    else if (pos < 0) {
        auto ub = rightmost_key.upper_bound(pos);
        if (ub == rightmost_key.end() || ub->first > 0) {
            memo[pos] = -pos;
        }
        else {
            memo[pos] = (long long)ub->first - pos + min_time(ub->first);
        }
    }
    else {
        auto lb = leftmost_key.lower_bound(pos);
        if (lb == leftmost_key.begin() || prev(lb)->first < 0) {
            memo[pos] = pos;
        }
        else {
            memo[pos] = (long long)pos - prev(lb)->first + min_time(prev(lb)->first);
        }
    }
    memo[pos] = min(memo[pos], INF);
    return memo[pos];
}

void solve() {
    memo.clear();
    leftmost_key.clear();
    rightmost_key.clear();
    int n, s, h;
    cin >> n >> s >> h;
    h -= s;
    vector<pair<int, int>> gates(n);
    for (int i = 0; i < n; ++i) {
        int k, g;
        cin >> k >> g;
        k -= s;
        g -= s;
        gates[i] = {g, k};
        if (g < 0 && k < g) {
            memo[g] = INF;
        }
        if (g > 0 && k > g) {
            memo[g] = INF;
        }
    }
    sort(gates.begin(), gates.end());
    //cout << "hi1" << endl;
    bool was_pos = false;
    bool was_inf = false;
    int curr = 1000000000;
    for (int i = 0; i < n; ++i) {
        if (gates[i].first > 0) {
            was_pos = true;
        }
        if (was_pos && memo.count(gates[i].first)) {
            was_inf = true;
        }
        if (was_inf) {
            memo[gates[i].first] = INF;
        }
        if (was_pos) {
            curr = min(curr, gates[i].second);
            leftmost_key[gates[i].first] = curr;
        }
    }
    bool was_neg = false;
    was_inf = false;
    curr = -1000000000;
    for (int i = n - 1; i >= 0; --i) {
        if (gates[i].first < 0) {
            was_neg = true;
        }
        if (was_neg && memo.count(gates[i].first)) {
            was_inf = true;
        }
        if (was_inf) {
            memo[gates[i].first] = INF;
        }
        if (was_neg) {
            curr = max(curr, gates[i].second);
            rightmost_key[gates[i].first] = curr;
        }
    }
    //cout << "HI" << endl;
    if (h > 0) {
        auto lb = lower_bound(gates.begin(), gates.end(), pair<int, int>{h, 1000000000});
        if (lb == gates.begin() || prev(lb)->first < 0) {
            cout << h << '\n';
        }
        else if (min_time(prev(lb)->first) != INF){
            cout << (long long)h - prev(lb)->first + min_time(prev(lb)->first) << '\n';
        }
        else {
            cout << -1 << '\n';
        }
    }
    else {
        auto lb = lower_bound(gates.begin(), gates.end(), pair<int, int>{h, 1000000000});
        if (lb == gates.end() || lb->first > 0) {
            cout << -h << '\n';
        }
        else if (min_time(lb->first) != INF) {
            cout << (long long)lb->first - h + min_time(lb->first) << '\n';
        }
        else {
            cout << -1 << '\n';
        }
    }
}// TIP To <b>Run</b> code, press <shortcut actionId="Run"/> or click the <icon src="AllIcons.Actions.Execute"/> icon in the gutter.
int main() {
    // TIP Press <shortcut actionId="RenameElement"/> when your caret is at the <b>lang</b> variable name to see how CLion can help you rename it.
    cin.tie(nullptr);
    ios_base::sync_with_stdio(false);
    int t;
    cin >> t;
    for (int i = 0; i < t; ++i) {
        solve();
    }

    return 0;
    // TIP See CLion help at <a href="https://www.jetbrains.com/help/clion/">jetbrains.com/help/clion/</a>. Also, you can try interactive lessons for CLion by selecting 'Help | Learn IDE Features' from the main menu.
}