#include <iostream>
#include <algorithm>
#include <vector>
#include <bitset>
#include <map>
#include <set>
#include <deque>

#define ALL(X) X.begin(), X.end()

using namespace std;


bool query(int x, int y) {
    cout << "? " << x << " " << y << endl;
    char c;
    cin >> c;
    return c == 'W';
}

void solve(int n) {
    int st = 0;
    while (true) {
        st += 50;
        bool ch = query(st, st);
        bool fl = false;
        for (int i = 1; i < 4; i++) {
            if (query(st + i, st + i) != ch) {
                fl = true;
                break;
            }
        }
        if (fl) continue;
        set<pair<int, int>> good;
        set<pair<int, int>> used;
        deque<pair<int, int>> q;
        q.push_back({st, st});
        while (!q.empty() && good.size() < n) {
            auto [x, y] = q.front();
            q.pop_front();
            used.insert({x, y});
            if (!query(x, y)) continue;
            good.insert({x, y});
            for (int dx = -1; dx < 2; dx++) {
                for (int dy = -1; dy < 2; dy++) {
                    if (dx == 0 && dy == 0) continue;
                    if (used.contains({x + dx, y + dy})) continue;
                    q.push_back({x + dx, y + dy});
                }
            }
        }
        if (good.size() >= n) {
            cout << "!";
            for (auto [x, y] : good) {
                cout << " " << x << " " << y;
            }
            cout << endl;
            break;
        }
    }
}

int main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
    int t = 1;
    int n = 1;
    cin >> t >> n;
    while (t --> 0) {
        solve(n);
    }
    return 0;
}