//#pragma GCC optimize("O3,unroll-loops")
//#pragma GCC target("avx2,bmi,bmi2,lzcnt,popcnt")

#include <iostream>
#include <vector>
#include <iterator>
#include <cmath>
#include <algorithm>

using namespace std;
using ll=long long;

ll lb(ll n) {
	return logb(n);
}

vector<ll> contents;

//l%4 == 0, r%4 == 0
auto greedy(ll l, ll r, ll max_peak, int slots) -> bool {
	if (slots == 0) return l <= 0 && r >= 0;
	if (slots < 0) return false;
	if (l > r || max_peak < 4 || r < 0) {
		contents[slots - 1] = -1;
		return false;
	}

	const ll slot_limited = 2ll << slots;
	const ll starting_peak = min(slot_limited, max_peak);
	const ll this_score_absolute_r = starting_peak * (lb(starting_peak) - 1);
	if (l > this_score_absolute_r * slots) {
		contents[slots - 1] = -1;
		return false;
	}

	for (ll peak = starting_peak; peak > 2; peak /= 2) {
		contents[slots - 1] = peak;
		ll this_score_l = peak * (lb(peak) - 2);
		ll this_score_r = peak * (lb(peak) - 1);
		if (peak == slot_limited) this_score_r -= 4;
		if (greedy(
			l - this_score_r, r - this_score_l,
			peak, slots - 1)) return true;
	}
	return false;
};

int main()
{
	int n, k; cin >> n >> k;
	contents = vector(k, -1ll);

	for (int i = 0; i < n; i++) {
		ll h; cin >> h;
		if (h % 4 != 0) {
			cout << -1 << endl;
			continue;
		}
		if (!greedy(h, h, 0x80000000, k)) {
			cout << -1 << endl;
			continue;
		}
		cout << k - count(contents.begin(), contents.end(), -1ll) << " ";
		copy_if(
			contents.begin(),
			contents.end(),
			ostream_iterator<ll>(cout, " "), [](ll x) {return x > 0; }
		);
		cout << endl;
	}

	return 0;
}