#include <vector>
#include <string>
#include <iostream>
#include <set>
#include <map>
#include <algorithm>

using namespace std;

using ll = long long;
using vi = vector<ll>;
using vvi = vector<vi>;

const ll INF = (ll) 1e18;

void solve() {
    int n; cin >> n;
    vector<pair<string, string>> ss;
    map<string, set<string>> as, bs;
    for(int i=0; i<n; ++i) {
        string a, b; cin >> a >> b;
        as[a].insert(b);
        bs[b].insert(a);
        ss.emplace_back(a, b);
    }

    set<string> used_a, used_b;
    set<pair<string, string>> awaiting;
    for(int i=0; i<n; ++i) {
        string a = ss[i].first, b = ss[i].second;
        if(!awaiting.empty() && awaiting.find({a, b}) == awaiting.end()) {
            cout << "No\n";
            return;
        }
        if (used_a.find(a) == used_a.end()) {
            for(auto& new_b : as[a]) {
                awaiting.insert({a, new_b});
            }
            used_a.insert(a);
        }
        if (used_b.find(b) == used_b.end()) {
            for(auto& new_a : bs[b]) {
                awaiting.insert({new_a, b});
            }
            used_b.insert(b);
        }
        awaiting.erase({a, b});
    }
    cout << "Yes\n";
}

signed main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);

    int t = 1;
    cin >> t;
    while(t--) {
        solve();
    }
}