#include <bits/stdc++.h>

using namespace std;

/* G draft
void dfs(int v, vector<vector<int> > &g, vector<int> &color, int col, int &sz, int &mx)
{
    color[v] = col;
    sz++;
    mx = max(mx, v);
    for (auto u : g[v]) if (color[u] == -1) {
        dfs(u, g, color, col, sz, mx);
    }
}

void solve()
{
    int n, m;
    cin >> n >> m;
    vector<vector<int> > g(n);
    for (int i = 0; i < m; i++) {
        int f, t;
        cin >> f >> t;
        f--, t--;
        g[f].push_back(t);
        g[t].push_back(f);
    }

    vector<int> color(n, -1);
    vector<int> maxForColor(n);
    int col = 0;
    for (int i = 0; i < n; i++) {
        if (color[i] == -1) {
            int sz = 0;
            int mx = -1;
            dfs(i, g, color, col, sz, mx);
            if (sz % 2 == 1) {
                cout << -1 << "\n";
                return;
            }
            maxForColor[col] = mx;
            col++;
        }
    }

    for (int i = 0; i < n; i++) {
        cout << maxForColor[color[i]] + 1 << " ";
    }
    cout << "\n";
}
*/

long long minScore[30], maxScore[30];
int init;
int k;

void rec(int h, int d, int k, vector<int> &cur, vector<int> &ans, int reserve_hops)
{
    if (ans.size()) {
        return;
    }
    if (h == 0) {
        ans = cur;
        return;
    }
    if (k == 0) {
        return;
    }
    int hops = 0;
    for (int sel = d; sel >= 2; sel--) {
        if (minScore[sel] > h) {
            continue;
        }
        if (minScore[sel] <= h && h < maxScore[sel]) {
            int needTiles = sel - 1;
            if (needTiles <= k) {
                cur.push_back(1 << sel);
                rec(0, d, k - 1, cur, ans, reserve_hops - hops);
                return;
            }
        }
        if (h == maxScore[sel]) {
            int needTiles = sel;
            if (needTiles <= k) {
                cur.push_back(1 << sel);
                rec(0, d, k - 1, cur, ans, reserve_hops - hops);
                return;
            }
        }

        int needTiles = sel - 1;
        if (sel != 2 && needTiles <= k) {
            cur.push_back(1 << sel);
            rec(h - (maxScore[sel] - 4), d, k - 1, cur, ans, reserve_hops - hops);
            cur.pop_back();
        }
        if (ans.size()) {
            return;
        }
        needTiles = sel;
        if (needTiles <= k) {
            cur.push_back(1 << sel);
            rec(h - maxScore[sel], d, k - 1, cur, ans, reserve_hops - hops);
        }
        if (ans.size()) {
            return;
        }

        hops++;
        if (hops > reserve_hops) {
            return;
        }
    }
}

void solve()
{
    if (!init) {
        minScore[2] = 0, maxScore[2] = 4;
        for (int i = 3; i < 30; i++) {
            minScore[i] = 2 * minScore[i - 1] + (1 << (i));
            maxScore[i] = 2 * maxScore[i - 1] + (1 << (i));
        }

        // for (int i = 2; i < 30; i++) {
        //     cout << i << " -> " << minScore[i] << " " << maxScore[i] << "\n";
        // }
        init = 1;
    }

    int h;
    cin >> h;
    if (h % 4 != 0) {
        cout << -1 << "\n";
        return;
    }
    vector<int> cur, ans;
    rec(h, 29, k, cur, ans, 3);
    if (ans.size()) {
        cout << ans.size() << " ";
        for (auto e : ans) cout << e << " ";
        cout << "\n";
    } else {
        cout << -1 << "\n";
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    auto time1 = std::chrono::high_resolution_clock::now().time_since_epoch().count();
    int t = 1;
    cin >> t >> k;
    while (t--) {
        solve();
    }
    auto time2 = std::chrono::high_resolution_clock::now().time_since_epoch().count();
    // cout << (time2 - time1) / 1e9 << "\n";
}