import sys

first_line: list[int] = list(map(int, input().split()))
t_cases: int = first_line[0]
required_size: int = first_line[1]

DIRECTIONS = ( # dx, dy
    (1, 0),
    (1, -1),
    (1, 1),
    (0, 1),
    (0, -1),
    (-1, 0),
    (-1, 1),
    (-1, -1)  
)

def add_connected_points(x, y, chain: set[tuple], all_points):
    for dx, dy in DIRECTIONS:
        np = (x + dx, y + dy)
        if np not in all_points:
            chain.add(np)
    
def make_query(x, y):
    print(f"? {x} {y}")
    sys.stdout.flush()

for _ in range(t_cases):
    q: int = 30_000
    b_chain = []
    w_chain = []

    b_connected_points = set()
    w_connected_points = set()
    all_points = set()

    # Always start a game with the center
    make_query(0, 0)
    
    initial_color = input()
    if initial_color == "B":
        add_connected_points(0, 0, b_connected_points, {})
        b_chain.append((0, 0))
    else:
        add_connected_points(0, 0, w_connected_points, {})
        w_chain.append((0, 0))
    all_points.add((0, 0))
    
    while True:
        if len(b_chain) == required_size:
            print('! B ', end='')
            for p in b_chain:
                print(p[0], p[1], end=' ')
            print()
            break
        if len(w_chain) == required_size:
            print('! W ', end='')
            for p in w_chain:
                print(p[0], p[1], end=' ')
            print()
            break
            
        if intersection := b_connected_points.intersection(w_connected_points):
            # choose a random point from intersection
            next_point = next(iter(intersection))
        
            b_connected_points.remove(next_point)
            w_connected_points.remove(next_point)
        else:
            # inner chain should become empty now
            if len(b_chain) < len(w_chain):
                b_chain = []
                b_connected_points.clear()
                next_point = next(iter(w_connected_points))
                w_connected_points.remove(next_point)
            else:
                w_chain = []
                w_connected_points.clear()
                next_point = next(iter(b_connected_points))
                b_connected_points.remove(next_point)
            
        # add this point to the correct chain
        next_x, next_y = next_point
                
        make_query(next_x, next_y)
        color = input()
        if color == "B":
            b_chain.append(next_point)
            all_points.add(next_point)
            add_connected_points(next_x, next_y, b_connected_points, all_points)
        else:
            w_chain.append(next_point)
            all_points.add(next_point)
            add_connected_points(next_x, next_y, w_connected_points, all_points)
                
              
                
            
    
    
    
    