#include <bits/stdc++.h>

using namespace std;

void solve() {
    int n;
    cin >> n;
    vector<pair<string, string>> words;
    for (int i = 0; i < n; i++) {
        string w1, w2;
        cin >> w1 >> w2;
        words.emplace_back(w1, w2);
    }

    set<int> unused;
    for (int i = 1; i < n; i++) {
        unused.insert(i);
    }

    map<string, set<int>> first;
    map<string, set<int>> second;

    for (int i = 1; i < n; i++) {
        first[words[i].first].insert(i);
        second[words[i].second].insert(i);
    }

    bool ok = true;
    for (int i = 1; i < n; i++) {
        const auto& [prev_f, prev_s] = words[i - 1];
        const auto&[cur_f, cur_s] = words[i];
        if (prev_f == cur_f || prev_s == cur_s) {
            // ok
            unused.erase(i);
            first[cur_f].erase(i);
            second[cur_s].erase(i);
        } else {
            if (!first[prev_f].empty() || !second[prev_s].empty()) {
                ok = false;
                break;
            } else {
                if (!unused.contains(i)) {
                    ok = false;
                } else {
                    unused.erase(i);
                    first[cur_f].erase(i);
                    second[cur_s].erase(i);
                }
            }
        }
    }

    if (ok) {
        cout << "Yes" << endl;
    } else {
        cout << "No" << endl;
    }
}

int main() {
    int testc;
    cin >> testc;
    for (int _ = 0; _ < testc; _++) {
        solve();
    }
}