#pragma optimize("Ofast")

#include <iostream>
#include <vector>
#include <algorithm>
#include <string>
#include <map>
#include <array>
#include <set>
#include <iomanip>
#include <bitset>

using namespace std;
using ll = int;
using ld = long double;

struct operat
{
	char c;
	ll v;
	bool async;
};

const ll N = 2000 * 500 + 1;

operat input()
{
	char c; cin >> c;
	ll v; cin >> v;
	string type; cin >> type;

	bool async = true;
	if (type == "sync")
	{
		async = false;
	}

	return { c, v, async };
}

int main()
{
	ios::sync_with_stdio(false);
	cin.tie(0);
	cout.tie(0);

	ll n; cin >> n;

	vector<operat> ops(0);
	for (int i = 0; i < n; ++i)
	{
		ops.push_back(input());
	}

	vector<ll> eqs;
	vector<ll> suffsum(n + 1, 0);
	ll max_eq = -1;
	for (int i = n - 1; i >= 0; --i)
	{
		suffsum[i] = suffsum[i + 1];
		if (ops[i].c == '+')
		{
			suffsum[i] += ops[i].v;
		}
		else
		{
			if (ops[i].async)
			{
				eqs.push_back(ops[i].v);
			}
			max_eq = max(max_eq, i * 1);
		}
	}

	bitset<N> prefset;
	bitset<N> pure_prefset;
	bitset<N> ans;
	pure_prefset.set(0, true);

	if (max_eq == -1)
	{
		cout << 1 << '\n';
		return 0;
	}

	for (auto eq : eqs)
	{
		prefset.set(eq, true);
	}


	for (int i = 0; i < n; ++i)
	{
		// (i-1, i)
		if (max_eq < i)
		{
			ans |= prefset << suffsum[i];
		}
		if (ops[i].c == '=' && i == max_eq && !ops[i].async)
		{
			ans |= (pure_prefset << (ops[i].v + suffsum[i + 1]));
		}

		if (ops[i].c == '=' && ops[i].async)
		{
			eqs.push_back(ops[i].v);
		}
		if (ops[i].c == '+' && ops[i].async)
		{
			prefset |= (prefset << ops[i].v);
			pure_prefset |= (pure_prefset << ops[i].v);
		}
	}
	ans |= prefset;

	cout << ans.count() << '\n';

	return 0;
}
