#include <iostream>
#include <vector>
#include <algorithm>
#include <cassert>
#include <set>
#include <random>

using namespace std;

int limit = 0;

int ask(int x, int y)
{
    limit ++;
    if (limit > 30000)
    {
        exit(0);
    }
    cout << "? " << x << " " << y << endl;
    char c;
    cin >> c;
    return c == 'B';
}

using point = pair<int,int>;

const int bound=  1000000000;

int dxs[] = {0, 0, 1, 1, -1, -1, 1, -1};
int dys[] = {1, -1, -1, 1, -1, 1, 0, 0};

vector<point>get_close_points(point p)
{
    vector<point> close;
    for (int i = 0; i < 8; i++)
    {
        int nx = dxs[i] + p.first;
        int ny = dys[i] + p.second;
        if (-bound <= nx && nx <= bound && -bound <= ny && ny <= bound)
        {
            close.emplace_back(nx, ny);
        }
    }
    return close;
}

int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);

    int t;
    cin >> t;
    int n;
    cin >> n;
    mt19937 rnd(72);
    while (t--)
    {
        vector<point> opened_cells;
        set<point> opened_cells_set;
        uniform_int_distribution<int>coord(-bound, bound);
        opened_cells.emplace_back(coord(rnd), coord(rnd));
        // opened_cells.emplace_back(0, 0);
        opened_cells_set.emplace(opened_cells.front());
        int col = ask(opened_cells.front().first, opened_cells.front().second);
        while (opened_cells.size() < n)
        {

            bool has_vacant = false;
            for (const auto pa : opened_cells)
            {
                for (const auto n : get_close_points(pa))
                {
                    if (opened_cells_set.count(n) == 0)
                    {
                        has_vacant = true;
                        break;
                    }
                }
            }

            if (!has_vacant)
            {
                t++;
                goto out;
            }

            uniform_int_distribution<size_t>point_range(0, opened_cells.size() - 1);
            point c = opened_cells[point_range(rnd)];
            const auto neigh = get_close_points(c);
            if (neigh.size() == 0) continue;

            uniform_int_distribution<size_t>neig_range(0, neigh.size() - 1);
            point n = neigh[neig_range(rnd)];
            if (opened_cells_set.count(n))
            {
                continue;
            }
            opened_cells_set.insert(n);

            if (ask(n.first, n.second) == col)
            {
                opened_cells.push_back(n);
            }
        }
        cout << "! " << (col == 1 ? 'B' : 'W') << " ";
        for (const auto pa : opened_cells)
        {
            cout << pa.first << " " << pa.second << " ";
        } 
        cout << endl;
    out: do{} while(0);
    }

    return 0;
}