#include <iostream>
#include <vector>
#include <algorithm>
#include <cassert>
#include <set>
#include <random>

using namespace std;

int limit = 0;

int ask(int x, int y)
{
    limit ++;
    if (limit > 30000)
    {
        exit(0);
    }
    cout << "? " << x << " " << y << endl;
    char c;
    cin >> c;
    return c == 'B';
}

using point = pair<int,int>;

const int bound = 1000000000;

int dxs[] = {0, 0, 1, 1, -1, -1, 1, -1};
int dys[] = {1, -1, -1, 1, -1, 1, 0, 0};

vector<point>get_close_points(point p)
{
    vector<point> close;
    for (int i = 0; i < 8; i++)
    {
        int nx = dxs[i] + p.first;
        int ny = dys[i] + p.second;
        if (-bound <= nx && nx <= bound && -bound <= ny && ny <= bound)
        {
            close.emplace_back(nx, ny);
        }
    }
    return close;
}

int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);

    int t;
    cin >> t;
    int n;
    cin >> n;
    
    mt19937 rnd(239);
    uniform_int_distribution<int>coord(-bound, bound);

    while (t--)
    {
        set<point> white_cells;
        set<point> black_cells;
        
        if (ask(0, 0))
        {
            black_cells.emplace(0, 0);
        }
        else
        {
            white_cells.emplace(0, 0);
        }

        for (int i = 1; i < n; i++)
        {
            if (ask(0, i))
            {
                black_cells.emplace(0, i);
            }
            else
            {
                white_cells.emplace(0, i);
                break;
            }
        }

        while (black_cells.size() < n && white_cells.size() < n)
        {
            bool found = false;
            for (const auto& p : black_cells)
            {
                bool has_vacant = false;
                point vac;
                for (const auto& n : get_close_points(p))
                {
                    if (black_cells.count(n) || white_cells.count(n))
                    {
                        continue;
                    }

                    bool has_white = false;
                    for (const auto& nw : get_close_points(n))
                    {
                        if (white_cells.count(nw))
                        {
                            has_white = true;
                            break;
                        }
                    }

                    if (has_white)
                    {
                        has_vacant = true;
                        vac = n;
                        break;
                    }
                }

                if (has_vacant)
                {
                    if (ask(vac.first, vac.second))
                    {
                        black_cells.insert(vac);
                    }
                    else{
                        white_cells.insert(vac);
                    }
                    found = true;
                    break;
                }
            }
            if (!found)
            {
                t++;
                goto out;
            }
        }

        if (black_cells.size() == n)
        {
            cout << "! " << 'B' << " ";
            for (const auto pa : black_cells)
            {
                cout << pa.first << " " << pa.second << " ";
            } 
            cout << endl;
        }
        else
        {
            cout << "! " << 'W' << " ";
            for (const auto pa : white_cells)
            {
                cout << pa.first << " " << pa.second << " ";
            }
            cout << endl;
        }

        out: do{} while(0);
    }

    return 0;
}