#include <bits/stdc++.h>

#define ll long long
#define ull unsigned long long
#define ld long double
#define print_lst_1x(lst) for (auto el: lst){cout << el << ' ';} cout << endl;
#define print_lst_2x(lst) for (auto el: lst){for (auto zn: el) {cout << zn << ' ';} cout << '\n';} cout << endl;
using namespace std;


template<typename S>
ostream &operator<<(ostream &os, const vector<S> &vector) {
    for (auto i: vector) {
        os << i << " ";
    }
    return os;
}


void solve_M() {
    int n;
    long long s;
    cin >> n >> s;

    const int MOD = 999983;

    unordered_set<int> V;

    for (int i = 0; i < n; ++i) {
        s = (s * 618023 + 1) % MOD;

        int c = 0;
        for (int x: V) {
            int y = s - x;
            if (y > x && V.count(y)) {
                ++c;
            }
        }

        if (c % 2 == 0) {
            V.insert((int) s);
        }
    }

    cout << V.size() << "\n";
}


const ll MOD = 1e9 + 7;


long long mod_pow(ll a, ll e) {
    ll r = 1;
    while (e) {
        if (e & 1) r = r * a % MOD;
        a = a * a % MOD;
        e >>= 1;
    }
    return r;
}


ll C(vector<ll> &fact, vector<ll> &invfact, ll n, ll k) {
    if (k < 0 || k > n) {
        return 0;
    }
    return fact[n] * invfact[k] % MOD * invfact[n - k] % MOD;
};


void solve_N() {
    int t;
    cin >> t;
    vector<ll> P(t), M(t);

    ll maxP = 0;
    for (int i = 0; i < t; i++) {
        cin >> P[i] >> M[i];
        maxP = max(maxP, P[i]);
    }

    ll LIM = 2 * maxP;
    vector<ll> fact(LIM + 1);
    vector<ll> invfact(LIM + 1);
    fact[0] = 1;

    for (int i = 1; i <= LIM; i++) {
        fact[i] = fact[i - 1] * i % MOD;
    }

    invfact[LIM] = mod_pow(fact[LIM], MOD - 2);

    for (int i = LIM; i > 0; i--) {
        invfact[i - 1] = invfact[i] * i % MOD;
    }

    for (int i = 0; i < t; i++) {
        ll p = P[i];
        ll m = M[i];

        ll E0 = mod_pow(4, p) * mod_pow(C(fact, invfact, 2 * p, p), MOD - 2) % MOD;

        ll n = (m + 2 * p + 1) % MOD;
        ll di = mod_pow((2 * p + 1) % MOD, MOD - 2);
        ll ans = E0 * n % MOD * di % MOD;

        cout << ans << '\n';
    }
}


int main() {
    int t = 1;
//    cin >> t;
    while (t--) {
        solve_N();
    }
    return 0;
}




