#include <bits/allocator.h>

#ifndef DEBUG
#pragma GCC optimize ("O3,unroll-loops")
#pragma GCC target("avx2,bmi,bmi2,lzcnt,popcnt")
#endif

#include <bits/stdc++.h>

using namespace std;

using ll = long long;
using ld = long double;
using pll = pair<ll, ll>;
using vll = vector<ll>;
using vpl = vector<pll>;
using vbo = vector<bool>;
using vvl = vector<vll>;
using vvp = vector<vpl>;

#define all(a) a.begin(),a.end()
#define sz(a) (ll)a.size()

#define FOR(i, a, ...) for(ll i = 0 __VA_OPT__(+ (a)); i < (a) __VA_OPT__(+ __VA_ARGS__ - (a)); ++i)
#define ROF(i, a, ...) for(int i = (a - 1) __VA_OPT__(+ __VA_ARGS__ - (a)); i >= 0 __VA_OPT__(+ (a)); --i)
#define each(i, a) for(auto& i : a)

const ll MOD = 999983;


struct mint {
    int x = 0;

    mint() {}

    mint(ll _x) : x(_x % MOD) {}

    mint& operator+=(mint other) {
        x += other.x;
        x -= x >= MOD ? MOD : 0;
        return *this;
    }

    mint& operator-=(mint other) {
        x += MOD - other.x;
        x -= x >= MOD ? MOD : 0;
        return *this;
    }

    mint& operator*=(mint other) {
        x = (long long) x * other.x % MOD;
        return *this;
    }

    mint operator+(mint other) const {
        mint res = *this;
        res += other;
        return res;
    }

    mint operator-(mint other) const {
        mint res = *this;
        res -= other;
        return res;
    }

    mint operator*(mint other) const {
        mint res = *this;
        res *= other;
        return res;
    }

    std::weak_ordering operator<=>(const mint& other) const {
        return x <=> other.x;
    }

    mint bin_pow(ll n) const {
        if (n == 0) {
            return 1;
        }
        if (n % 2 == 1) {
            return *this * bin_pow(n - 1);
        }
        mint h = bin_pow(n / 2);
        return h * h;
    }

    mint rev() const {
        return bin_pow(MOD - 2);
    }

    mint& operator/=(const mint& other) {
        *this *= other.rev();
        return *this;
    }

    mint operator/(const mint& other) const {
        mint res = *this;
        res /= other;
        return res;
    }
};

mint p = 618023;

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    ll n;
    cin >> n;
    ll y;
    cin >> y;
    mint x = y;
    bitset<MOD> bs;
    bitset<MOD> pos;
    ll cnt = 0;
    FOR(i, n) {
        x = x * p + 1;
        if (!pos[x.x] && !bs[x.x]) {
            pos ^= bs << x.x;
            bs[x.x] = 1;
            cnt++;
        }
    }
    cout << cnt;
}