#include <bits/stdc++.h>

inline std::mt19937_64 rng_64(std::chrono::steady_clock::now().time_since_epoch().count());

template<typename T1, typename T2>
long long randlong(const T1 &low, const T2 &high) {
    return static_cast<long long>(low) + rng_64() % static_cast<long long>(high - low + 1);
}

using namespace std;
using ll = long long;

inline int cost(ll x) {
    int res = 0;
    while (x) {
        x /= 10;
        res++;
    }
    return res;
}

inline int get(ll x) {
    int res = 0;
    while (x != 1) {
        if (x & 1) {
            x = x * 3 + 1;
        } else {
            x = x >> 1;
        }
        res += cost(x);
    }
    return res;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int T;
    cin >> T;
    while (T--) {
        ll x;
        cin >> x;
        while (x > 1) {
            if (x % 2 == 0) {
                cout << "Collatz" << endl;
                cin >> x;
                continue;
            }
            ll s = 0;
            for (int i = 0; i < 100; ++i) {
                ll t = randlong(3 * x + 1, 6 * x);
                s += get(t);
            }
            if (get(x) * 100 < s) {
                cout << "Collatz" << endl;
                cin >> x;
            } else {
                cout << "Random" << endl;
                cin >> x;
            }
        }
    }
}
