#include <bits/stdc++.h>

using namespace std;
using ll = long long;

vector<vector<vector<int>>> triangles;
vector<vector<int>> hex_grid;
int n;

void interact_with_hex(int type) {
    vector<function<pair<int, int>(int, int)>> indices = {
        [n=n](int i, int j) {return pair(i, i + j);},
        [n=n](int i, int j) {return pair(i + j, n - 1 + j);},
        [n=n](int i, int j) {return pair(n - 1 + j, 2 * n - 2 - i - j);},
        [n=n](int i, int j) {return pair(2 * n - 2 - i, n - 1 - j);},
        [n=n](int i, int j) {return pair(2 * n - 2 - i - j, i);},
        [n=n](int i, int j) {return pair(n - 1 - j, i);}
    };
    for (int tr = 0; tr < 6; tr++) {
        for (int i = 0; i < n; i++) {
            for (int j = 0; j < n - i; j++) {
                auto [hi, hj] = indices[tr](i, j);
                if (type == 1) {
                    triangles[tr][i][j] = hex_grid[hi][hj];
                }
                else {
                    hex_grid[hi][hj] = triangles[tr][i][j];
                }
            }
        }
    }
}

void print_triangles() {
    for (int tr = 0; tr < 6; tr++) {
        for (int i = 0; i < n; i++) {
            for (int j = 0; j < n - i; j++) {
                cout << triangles[tr][i][j] << " ";
            }
            cout << endl;
        }
        cout << endl;
    }
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    cin >> n;
    hex_grid.resize(2 * n - 1);
    for (int i = - (n - 1); i <= (n - 1); i++) {
        hex_grid[n - 1 + i].resize(2 * n - 1 - abs(i));
        for (int j = 0; j < 2 * n - 1 - abs(i); j++) {
            cin >> hex_grid[n - 1 + i][j];
        }
    }
    triangles.resize(6);
    for (int i = 0; i < 6; i++) {
        triangles[i].resize(n);
        for (int j = 0; j < n; j++) {
            triangles[i][j].resize(n - j);
        }
    }
    interact_with_hex(1);
    string queries;
    cin >> queries;
    bool is_transposed = false;
    int rotation = 0;
    for (char c: queries) {
        if (c == 'R') {
            rotation -= 1;
            if (rotation < 0) {rotation += 6;}
        }
        else if (c == 'L') {
            rotation += 1;
            if (rotation >= 6) {rotation -= 6;}
        }
        else {
            is_transposed = !is_transposed;
            rotation = 6 - rotation;
            if (rotation == 6) rotation = 0;
        }
    }
    if (is_transposed) {
        swap(triangles[1], triangles[5]);
        swap(triangles[2], triangles[4]);
        for (int tr = 0; tr < 6; tr++) {
            for (int i = 0; i < n; i++) {
                ranges::reverse(triangles[tr][i]);
            }
        }
    }
    vector<int> order(6);
    for (int i = 0; i < 6; i++) {
        order[i] = (i + rotation) % 6;
    }
    auto new_triangles = triangles;
    for (int i = 0; i < 6; i++) {
        triangles[i] = new_triangles[order[i]];
    }
    interact_with_hex(2);
    for (int i = - (n - 1); i <= (n - 1); i++) {
        for (int j = 0; j < 2 * n - 1 - abs(i); j++) {
            cout << hex_grid[n - 1 + i][j] << " ";
        }
        cout << "\n";
    }
}
