#include <iostream>
#include <vector>
#include <set>
#include <utility>

void solve() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);

    int H, M;
    std::cin >> H >> M;

    std::set<std::pair<int, int>> lucky_times;

    if (39 < M) {
        for (int x = 0; x < 10; ++x) {
            int hours = x * 10 + 2;
            if (hours < H) {
                lucky_times.insert({hours, 39});
            }
        }
    }
    
    if (39 < M) {
        const std::vector<int> x_values = {0, 2, 3};
        for (int x : x_values) {
            int hours = 20 + x;
            if (hours < H) {
                lucky_times.insert({hours, 39});
            }
        }
    }

    if (23 < H) {
        const std::vector<int> x_values = {0, 3, 9};
        for (int x : x_values) {
            int minutes = x * 10 + 9;
            if (minutes < M) {
                lucky_times.insert({23, minutes});
            }
        }
    }

    if (23 < H) {
        for (int x = 0; x < 10; ++x) {
            int minutes = 90 + x;
            if (minutes < M) {
                lucky_times.insert({23, minutes});
            }
        }
    }

    std::cout << lucky_times.size() << std::endl;
}

int main() {
    solve();
    return 0;
}
