#include <iostream>
#include <vector>
#include <numeric>

int main() {
    int n;
    long long s;
    std::cin >> n >> s;

    const int MOD = 999983;
    const int MULT = 618023;

    std::vector<int> v_elements;
    std::vector<bool> exists(MOD, false);

    for (int i = 0; i < n; ++i) {
        s = (s * MULT + 1) % MOD;

        int pair_count = 0;
        for (int a : v_elements) {
            int b = s - a;
            if (a <= b) {
                if (b >= 0 && b < MOD && exists[b]) {
                    pair_count++;
                }
            }
        }

        if (pair_count % 2 == 0) {
            if (!exists[s]) {
                v_elements.push_back(s);
                exists[s] = true;
            }
        }
    }

    std::cout << v_elements.size() << std::endl;

    return 0;
}