#include <iostream>
#include <vector>
#include <cstdint>
#include <cstdio>

int main() {
    int n;
    long long s;
    if (!(std::cin >> n >> s)) return 0;

    const int M = 999983;   
    const int MAXSUM = 2 * (M - 1);     
    const int LEN_V = (M + 63) / 64;   
    const int LEN_P = (MAXSUM + 1 + 63) / 64; 

    std::vector<uint64_t> Vbits(LEN_V, 0);
    std::vector<uint64_t> Pbits(LEN_P, 0); 

    std::vector<char> inSet(M, 0);

    int sizeV = 0;

    auto get_bit = [](const std::vector<uint64_t>& arr, int idx)->int {
        int w = idx >> 6;
        int b = idx & 63;
        return (arr[w] >> b) & 1ULL;
        };

    auto flip_bit = [&](std::vector<uint64_t>& arr, int idx) {
        int w = idx >> 6;
        int b = idx & 63;
        arr[w] ^= (1ULL << b);
        };

    auto xor_shifted_into = [&](const std::vector<uint64_t>& src, std::vector<uint64_t>& dest, int shift_bits) {
        if (shift_bits < 0) return;
        int whole = shift_bits >> 6;
        int rem = shift_bits & 63;  

        int src_len = (int)src.size();
        int dest_len = (int)dest.size();

        if (rem == 0) {
            for (int i = src_len - 1; i >= 0; --i) {
                int dest_idx = i + whole;
                if (dest_idx < 0) continue;
                if (dest_idx >= dest_len) continue;
                dest[dest_idx] ^= src[i];
            }
        }
        else {
            for (int i = src_len - 1; i >= 0; --i) {
                uint64_t w = src[i];
                if (w == 0) continue;
                int dest_idx = i + whole;
                if (dest_idx < dest_len) {
                    dest[dest_idx] ^= (w << rem);
                }
                if (dest_idx + 1 < dest_len && rem != 0) {
                    dest[dest_idx + 1] ^= (w >> (64 - rem));
                }
            }
        }
        };

    for (int step = 0; step < n; ++step) {
        s = ((s * 618023LL) + 1LL) % M;
        int si = (int)s;
        int parity = get_bit(Pbits, si);

        if (parity == 0) {
            if (!inSet[si]) {
                xor_shifted_into(Vbits, Pbits, si);
                int two = si + si;
                if (two <= MAXSUM) flip_bit(Pbits, two);
                inSet[si] = 1;
                int word = si >> 6;
                int bit = si & 63;
                Vbits[word] |= (1ULL << bit);
                ++sizeV;
            }
        }
    }
    std::cout << sizeV << "\n";
    return 0;
}
