#include <iostream>
#include <vector>
using namespace std;

const int MOD = 1000000007;

long long mod_pow(long long a, long long b, long long mod) {
    long long result = 1;
    while (b > 0) {
        if (b & 1) {
            result = (result * a) % mod;
        }
        a = (a * a) % mod;
        b >>= 1;
    }
    return result;
}


long long mod_inv(long long a, long long mod) {
    return mod_pow(a, mod - 2, mod);
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int t;
    cin >> t;

    while (t--) {
        long long p, m;
        cin >> p >> m;


        long long numerator = (2 * p + m + 1) % MOD;
        long long denominator = (p + 1) % MOD;


        long long n = 2 * p + m;
        long long num = (n + 1) % MOD;
        long long den = (2 * p + 1 - m) % MOD;  \


        long long result = 1;
        for (int i = 0; i < p; i++) {
            long long term_num = (2 * p + m - 2 * i - 1) % MOD;
            long long term_den = (2 * p + m - i) % MOD;
            result = (result + term_num * mod_inv(term_den, MOD)) % MOD;
        }

        cout << result << "\n";
    }

    return 0;
}
