#include <iostream>
#include <vector>
using namespace std;

const int MOD = 999983;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n, s;
    cin >> n >> s;

    vector<bool> exists(MOD, false);
    int count = 0;

    for (int step = 0; step < n; step++) {
        s = (1LL * s * 618023 + 1) % MOD;

        int pairs = 0;

        // Используем идею: перебираем только половину возможных значений
        for (int a = 0; a <= s / 2; a++) {
            int b = s - a;
            if (b < MOD && exists[a] && exists[b]) {
                if (a == b) {
                    // В множестве каждый элемент уникален, так что пара (a,a) невозможна
                } else {
                    pairs++;
                }
            }
        }

        if (pairs % 2 == 0 && !exists[s]) {
            exists[s] = true;
            count++;
        }
    }

    cout << count << endl;

    return 0;
}
