#include <iostream>
#include <bitset>
#include <vector>

using namespace std;

const int MOD = 999983;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    
    int n, s;
    cin >> n >> s;
    
    bitset<MOD> in_set;
    vector<int> elements;
    elements.reserve(n);
    int count = 0;
    
    long long current = s;
    for (int i = 0; i < n; i++) {
        current = (current * 618023 + 1) % MOD;
        int num = current;
        
        int pairs = 0;
        int size = elements.size();
        
        for (int j = 0; j < size; j++) {
            int x = elements[j];
            int y = num - x;
            if (y < 0 || y >= MOD) continue;
            if (!in_set[y]) continue;
            if (x <= y) {
                pairs++;
                if (pairs & 1) {
                    if (j * 2 > size) break;
                }
            }
        }
        
        if ((pairs & 1) == 0) {
            in_set[num] = true;
            elements.push_back(num);
            count++;
        }
    }
    
    cout << count << endl;
    
    return 0;
}