import sys

input = sys.stdin.readline

pattern = ['A', 'B', 'C', 'D', 'E', 'F', 'G']
keyboard = pattern * 7 + ['A', 'B', 'C']
positions = {ch: [] for ch in 'ABCDEFG'}
for i, note in enumerate(keyboard):
    positions[note].append(i)

t = int(input().strip())
for _ in range(t):
    melody = input().strip()
    current = set(positions[melody[0]])
    ok = True
    for ch in melody[1:]:
        next_set = set()
        for prev in current:
            for pos in positions[ch]:
                if abs(pos - prev) <= 3:
                    next_set.add(pos)
        current = next_set
        if not current:
            ok = False
            break
    print("YES" if ok else "NO")
