#include <bits/stdc++.h>
using namespace std;

#define ll long long
#define all(x) (x).begin(), (x).end()

struct r {
    int x, y;
};

r operator+(r a, r b) { return {a.x + b.x, a.y + b.y}; }
r operator-(r a, r b) { return {a.x - b.x, a.y - b.y}; }
int operator*(r a, r b) { return a.x * b.x + a.y * b.y; }
int operator^(r a, r b) { return a.x * b.y - a.y * b.x; }
bool operator==(r a, r b) { return a.x == b.x && a.y == b.y; }
bool operator!=(r a, r b) { return !(a == b); }

vector<r> jarvis(vector<r>& points) {
    r p0 = points[0];
    for (r p : points) {
        if (p.x < p0.x || (p.x == p0.x && p.y < p0.y)) {
            p0 = p;
        }
    }
    vector<r> hull = {p0};
    r t = (points[0] == p0 ? points[1] : points[0]);
    while (true) {
        for (r p : points) {
            if (((p - p0) ^ (t - p0)) > 0) {
                t = p;
            }
        }
        if (t != p0) {
            p0 = t;
            hull.push_back(t);
        } else break;
    }
    return hull;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    cin >> n;
    vector<r> a(n);
    for (int i = 0; i < n; i++) {
        cin >> a[i].x >> a[i].y;
    }
    vector <r> hull = jarvis(a);
    r normal = {0, 0};
    r p0 = hull[0], p1 = hull[0];
    for (r a : hull) {
        for (r b : hull) {
            r newnormal = a - b;
            if (hypot(newnormal.x, newnormal.y) > hypot(normal.x, normal.y)) {
                normal = newnormal;
                p0 = a;
                p1 = b;
            }
        }
    }
    cout << normal.x << ' ' << normal.y << ' ' << -(normal.x * p0.x + normal.y * p0.y) << '\n';
    cout << normal.x << ' ' << normal.y << ' ' << -(normal.x * p1.x + normal.y * p1.y) << '\n';

    return 0;
}