#include <bits/stdc++.h>
using namespace std;

static inline bool is_even(const string& s){
    return !s.empty() && ((s.back() - '0') % 2 == 0);
}

static inline int mod_pow2(const string& s, int k){
    int m = 1 << k, r = 0;
    for(char c : s){
        if(c >= '0' && c <= '9') r = (r * 10 + (c - '0')) % m;
    }
    return r;
}

static inline int choose_k(size_t len){
    if(len <= 3)  return 6;
    if(len <= 6)  return 8;
    if(len <= 9)  return 10;
    if(len <= 12) return 12;
    return 14;
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    if(!(cin >> t)) return 0;

    for(int round = 0; round < t; ++round){
        string x;
        if(!(cin >> x)) return 0;

        while(true){
            if(x == "0") return 0;
            if(x == "1") break;

            if(is_even(x)){
                cout << "collatz\n" << flush;
                if(!(cin >> x)) return 0;
                continue;
            }

            int k = choose_k(x.size());
            const int MAX_TRIES = 18;
            const size_t max_len = x.size() + 2;

            bool good = false;
            for(int tries = 0; tries < MAX_TRIES; ++tries){
                cout << "random\n" << flush;
                if(!(cin >> x)) return 0;
                if(x == "0") return 0;
                if(x == "1"){ good = true; break; }

                if(mod_pow2(x, k) == 0){
                    good = true;
                    break;
                }
                if(x.size() > max_len) break;
            }
            if(x == "1") break;
            if(x == "0") return 0;

            if(!good && !is_even(x)){
                cout << "collatz\n" << flush;
                if(!(cin >> x)) return 0;
            }
        }
    }
    return 0;
}
