import functools
import math
import random
from math import *


def predict(x):
    # c0, c1, c2, c3 = [23.66630191, -11.28058632, 50.68824006, 17.8892227]
    # c0, c1, c2, c3 = [13.05906915, -3.04491545, 18.74596942, 13.68213545]
    c0, c1, c2, c3 = [8.84333442, 2.79976936, 5.14145203, 10.8532312]
    # c0, c1, c2, c3 = [7.33339905, 4.5764832, 2.32344402, 9.47674718]
    # c0, c1, c2, c3 = [6.50195413, 5.31452853, 2.06126484, 8.68087199]
    # c0, c1, c2, c3 = [5.9267185, 5.68618861, 2.37096923, 8.2006941]
    l = log(max(1, x))
    ll = log(max(1, l))
    return c0 + c1 * l + c2 * ll + c3 * l * ll


def solve(x, dry=False):
    cost = 0
    penalty = 1 / 1.1
    while True:
        penalty *= 1.1
        if x == 1:
            break
        best_score = predict(x) * penalty
        best_iter = 0
        cur = 0
        iter = 0
        y = x
        while y != 1:
            if y % 2 == 0:
                y //= 2
            else:
                y = y * 3 + 1
            iter += 1
            cur += floor(log10(y) + 1)
            score = cur + predict(y) * penalty
            if best_score > score:
                best_score = score
                best_iter = iter
            if cur > best_score:
                break
        for i in range(best_iter):
            if not dry: print("collatz", flush=True)
            if x % 2 == 0:
                x //= 2
            else:
                x = x * 3 + 1
            cost += floor(log10(x) + 1)
            if not dry: assert x == int(input())
        if x != 1:
            x = random.randint(3 * x + 1, 6 * x)
            cost += floor(log10(x) + 1)
            if not dry:
                print("random", flush=True)
                x = int(input())
    return cost


# N = 10000
# res = [(solve(random.randrange(2, 10 ** 7)), print(i))[0] for i in range(N)]
# print(sum(res) / N)


TESTS = int(input())
for _ in range(TESTS):
    solve(int(input()))
