#include <iostream>
#include <cmath>
#include <iomanip>
#include <vector>
#include <algorithm>
using namespace std;

struct Point {
    double x, y;
};

double point_to_line_distance(double x, double y, double a, double b, double c) {
    return abs(a * x + b * y + c) / sqrt(a * a + b * b);
}

int main() {
    vector<Point> points(4);
    for (int i = 0; i < 4; i++) {
        cin >> points[i].x >> points[i].y;
    }
    
    // Находим стороны прямоугольника
    double width = sqrt(pow(points[0].x - points[1].x, 2) + pow(points[0].y - points[1].y, 2));
    double height = sqrt(pow(points[1].x - points[2].x, 2) + pow(points[1].y - points[2].y, 2));
    

    double a = width / 2.0;
    double b = height / 2.0;
    double area = M_PI * a * b;
    
    cout << fixed << setprecision(8) << area << endl;
    return 0;
}