#include <iostream>
#include <vector>
#include <algorithm>

namespace T {
    const int M = 999983;
    const int R = 5;

    long long p(long long b, long long e) {
        long long r = 1;
        b %= M;
        while (e > 0) {
            if (e % 2 == 1) r = (r * b) % M;
            b = (b * b) % M;
            e /= 2;
        }
        return r;
    }

    void t(std::vector<long long>& a, bool i) {
        int n = a.size();
        for (int x = 1, y = 0; x < n; x++) {
            int z = n >> 1;
            for (; y & z; z >>= 1) y ^= z;
            y ^= z;
            if (x < y) std::swap(a[x], a[y]);
        }

        for (int l = 2; l <= n; l <<= 1) {
            long long w = p(R, (M - 1) / l);
            if (i) w = p(w, M - 2);
            for (int x = 0; x < n; x += l) {
                long long u = 1;
                for (int y = 0; y < l / 2; y++) {
                    long long a1 = a[x + y], a2 = (a[x + y + l / 2] * u) % M;
                    a[x + y] = (a1 + a2) % M;
                    a[x + y + l / 2] = (a1 - a2 + M) % M;
                    u = (u * w) % M;
                }
            }
        }

        if (i) {
            long long ni = p(n, M - 2);
            for (long long& x : a) x = (x * ni) % M;
        }
    }
}

const int M = 999983;
const int B = 384;

int main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);

    int n;
    long long s;
    std::cin >> n >> s;

    int z = 1;
    while (z < 2 * M) z <<= 1;

    std::vector<int> vb, vn;
    std::vector<bool> eb(M, false), et(M, false);
    std::vector<char> pb(2 * M, 0);

    auto r = [&]() {
        if (vn.empty()) return;

        vb.insert(vb.end(), vn.begin(), vn.end());
        for (int x : vn) eb[x] = true;
        vn.clear();

        std::vector<long long> p1(z, 0);
        for (int x : vb) p1[x] = 1;

        T::t(p1, false);
        for (int i = 0; i < z; ++i) p1[i] = (p1[i] * p1[i]) % M;
        T::t(p1, true);

        for (int i = 0; i < 2 * M; ++i) {
            long long c = p1[i];
            if (i % 2 == 0 && eb[i / 2]) c++;
            pb[i] = (c / 2) % 2;
        }
    };

    for (int i = 0; i < n; ++i) {
        s = (s * 618023LL + 1) % M;
        int x = (int)s;

        int p = pb[x];

        for (int a : vn) {
            int b = x - a;
            if (b >= 0 && b < M && eb[b]) p ^= 1;
        }

        for (int j = 0; j < vn.size(); ++j) {
            for (int k = j; k < vn.size(); ++k) {
                if (vn[j] + vn[k] == x) p ^= 1;
            }
        }

        if (p == 0) {
            if (!et[x]) {
                et[x] = true;
                vn.push_back(x);
                if (vn.size() >= B) r();
            }
        }
    }

    r();
    std::cout << vb.size() << "\n";
    return 0;
}
