#include <bits/stdc++.h>
using namespace std;

const long long MOD = 1000000007;

long long mod_pow(long long a, long long e) {
  long long r = 1;
  while (e) {
    if (e & 1) r = r * a % MOD;
    a = a * a % MOD;
    e >>= 1;
  }
  return r;
}

long long mod_inv(long long x) {
  return mod_pow(x, MOD - 2);
}

int main() {
  ios::sync_with_stdio(false);
  cin.tie(0);

  int t;
  cin >> t;

  while (t--) {
    int p, m;
    cin >> p >> m;

    long long comb = 1;
    for (int i = 1; i <= p; i++) {
      comb = comb * (2 * p - i + 1) % MOD;
      comb = comb * mod_inv(i) % MOD;
    }

    long long num = (2 * p + m + 1) % MOD * mod_pow(4, p) % MOD;
    long long den = (2 * p + 1) % MOD * comb % MOD;
    long long ans = num * mod_inv(den) % MOD;

    cout << ans << "\n";
  }

  return 0;
}