#include <cassert>
#include <cmath>
#include <cstdint>
#include <iomanip>
#include <iostream>
#include <utility>
#include <vector>
#include <algorithm>

// #pragma GCC optimize("Ofast")
// #pragma GCC target("avx,avx2,fma")

using namespace std;

using i64 = int64_t;
using u64 = uint64_t;
// using i128 = __int128_t;

struct p { double x, y; };
bool operator<(p a, p b) {
    return make_pair(a.y, a.x) < make_pair(b.y, b.x);
}

double dist(p a, p b) {
    double t = a.x - b.x;
    double s = a.y - b.y;
    return sqrt(t * t + s * s);
}

const double kPi = acos(-1.0);

void solve() {
    vector<p> c(4);
    for (p& s : c) cin >> s.x >> s.y;
    // for (p x : c) cout << "(" << x.x << ' ' << x.y << ")\n";
    double d[] =  {
            dist(c[0], c[3]),
            dist(c[0], c[2]),
            dist(c[0], c[1])
    };
    sort(d, d + 3);

    cout << fixed << setprecision(7);
    cout << double(d[0]) * double(d[1]) * kPi / 4.0;
}

signed main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
    int t = 1;
    //cin >> t;
    while (t --> 0) {
        solve();
    }

    return 0;
}
