import javax.swing.text.html.parser.DTDConstants.NUMBERS
import kotlin.random.Random

private fun readln() = readLine()!!
private fun readlnLong() = readln().toLong()

private fun readlnStrings() = readln().split(' ')
private fun readlnInts() = readlnStrings().map { it.toInt() }
private fun readlnLongs() = readlnStrings().map { it.toLong() }

private fun isWhiteSpace(c: Char) = c in " \r\n\t"
private fun readString() = generateSequence { System.`in`.read().toChar() }
    .dropWhile { isWhiteSpace(it) }.takeWhile { !isWhiteSpace(it) }.joinToString("")

private fun readInt() = readString().toInt()
private fun readLong() = readString().toLong()
private fun readDouble() = readString().toDouble()

fun printw(any: Any?) {
    print(" $any")
}

const val MOD = 1_000_000_007L

const val ENABLE_PRECALC = false
const val NUMBER = 100_000
val FACTORIALS = if (ENABLE_PRECALC) {
    LongArray(NUMBER)
} else {
    LongArray(0)
}

class DSU(size: Int) {

    // Если el[i] < 0 -> i - представитель своей группы размером abs(el[i])
    // Если el[i] >= 0 -> el[i] ссылка на родителя
    val elements = IntArray(size) { -1 }

    fun find(i: Int): Int {
        val el = elements[i]

        return if (el >= 0) {
            elements[i] = find(el)

            elements[i]
        } else {
            i
        }
    }

    fun size(i: Int): Int {
        val el = find(i)

        return -elements[el]
    }

    fun union(a: Int, b: Int): Boolean {
        val aNode = find(a)
        val bNode = find(b)

        if (aNode == bNode) return false

        val aSize = size(aNode)
        val bSize = size(bNode)

        if (aSize > bSize) {
            elements[bNode] = aNode
            elements[aNode] = -(aSize + bSize)
        } else {
            elements[aNode] = bNode
            elements[bNode] = -(aSize + bSize)
        }

        return true
    }

    fun components(): Int = elements.count { it < 0 }

    fun getRoots(): List<Int> = elements.indices.filter { elements[it] < 0 }
}

class SegmentTree(private val arr: List<Long>, private val operator: (Long, Long) -> Long) {
    private val n = arr.size
    private val tree = LongArray(4 * n)

    init {
        build(0, 0, n - 1)
    }

    private fun build(node: Int, left: Int, right: Int) {
        if (left == right) {
            tree[node] = arr[left]
            return
        }

        val mid = (left + right) / 2
        build(2 * node + 1, left, mid)
        build(2 * node + 2, mid + 1, right)

        tree[node] = operator(tree[2 * node + 1], tree[2 * node + 2]) % MOD
    }

    fun update(index: Int, value: Long) {
        update(0, 0, n - 1, index, value)
    }

    private fun update(node: Int, left: Int, right: Int, index: Int, value: Long) {
        if (left == right) {
            tree[node] = value
            return
        }

        val mid = (left + right) / 2
        if (index <= mid) {
            update(2 * node + 1, left, mid, index, value)
        } else {
            update(2 * node + 2, mid + 1, right, index, value)
        }
        tree[node] = operator(tree[2 * node + 1], tree[2 * node + 2]) % MOD
    }

    fun query(left: Int, right: Int): Long {
        return query(0, 0, n - 1, left, right)
    }

    private fun query(node: Int, left: Int, right: Int, l: Int, r: Int): Long {
        if (r < left || l > right) return 0
        if (l <= left && right <= r) return tree[node]

        val mid = (left + right) / 2
        val leftValue = query(2 * node + 1, left, mid, l, r)
        val rightValue = query(2 * node + 2, mid + 1, right, l, r)
        return operator(leftValue, rightValue) % MOD
    }
}

fun precalc() {
    FACTORIALS[0] = 1
    for (i in (1..<NUMBER)) {
        FACTORIALS[i] = FACTORIALS[i - 1] * i % MOD
    }
}

fun inv(a: Long): Long {
    return pow(a, MOD - 2)
}

fun div(a: Long, b: Long): Long {
    return (a * inv(b)) % MOD
}

fun comb(n: Int, k: Int): Long {
    if (k !in 0..n) return 0L
    if (k == 0 || k == n) return 1L

    val numerator = FACTORIALS[n]
    val denominator = (FACTORIALS[k] * FACTORIALS[n - k]) % MOD
    return div(numerator, denominator)
}

fun pow(base: Long, exponent: Long): Long {
    if (exponent == 0L) return 1L

    val half = pow(base, exponent / 2)
    var result = (half * half) % MOD

    if (exponent % 2 == 1L) {
        result = (result * base) % MOD
    }

    return result
}

fun main() {
    if (ENABLE_PRECALC) {
        precalc()
    }

    var n = 1
//    n = readInt()
    repeat(n) {
        solve()
    }
}


fun solve() {
    val k = readInt() - 1

    if (k == -1) {
        solve1()
    } else {
        solve2(k)

    }
}

fun solve1() {
    val n = readInt()
    val numbers = List(n) { readInt() }

    val k = numbers.sum() % n

    if (n % 2 == 0) {
        println((k + n / 2) % n + 1)
    } else {
        println(k % n + 1)
    }
}

fun solve2(k: Int) {
    val n = readInt() + 1
    val numbers = List(n - 1) { readInt() }

    val sum = numbers.sum() % n
    val expectedValue = if (n % 2 == 0) {
        (k - sum + n + n/2 - 1) % n + 1

    } else {
        (k - sum + n - 1) % n + 1
    }

    println(expectedValue)
}


fun test() {
    val n = 17

    val numbers = List(n - 1) { Random.nextInt(1, n) }
}
//4
//5
//3 6 1 2 3