import math

def convex_hull(points):
    points = sorted(points)
    if len(points) <= 1:
        return points
    
    def cross(o, a, b):
        return (a[0]-o[0])*(b[1]-o[1]) - (a[1]-o[1])*(b[0]-o[0])
    
    lower = []
    for p in points:
        while len(lower) >= 2 and cross(lower[-2], lower[-1], p) <= 0:
            lower.pop()
        lower.append(p)
    
    upper = []
    for p in reversed(points):
        while len(upper) >= 2 and cross(upper[-2], upper[-1], p) <= 0:
            upper.pop()
        upper.append(p)
    
    return lower[:-1] + upper[:-1]

n = int(input())
pts = [tuple(map(int, input().split())) for _ in range(n)]
    
hull = convex_hull(pts)
m = len(hull)
    
best_dist = -1
best_a, best_b, best_c1, best_c2 = 0, 0, 0, 0
    
for i in range(m):
    for j in range(i+1, m):
        p1 = hull[i]
        p2 = hull[j]
        a = p2[0] - p1[0]
        b = p2[1] - p1[1]
            
        projections = [a*x + b*y for x, y in hull]
        mn, mx = min(projections), max(projections)
        dist = (mx - mn) / math.hypot(a, b)
            
        if dist > best_dist:
            best_dist = dist
            best_a, best_b, best_c1, best_c2 = a, b, mn, mx
    
print(best_a, best_b, -best_c1)
print(best_a, best_b, -best_c2)

