// #define _GLIBCXX_DEBUG 1
#include <iostream>
#include <vector>
#include <cmath>
#include <string>
#include <algorithm>
#include <set>
#include <queue>
#include <iomanip>
#include <map>
#include <fstream>

typedef long long ll;
typedef long double ld;
using namespace std;

ld EPS = 0.0000001;
ld pi = 3.14159265358979323846;

struct point
{
    ll x, y;
    point(ll x1, ll y1)
    {
        x = x1;
        y = y1;
    }
    point()
    {
        x = 0;
        y = 0;
    }
    point operator+(point b)
    {
        return point(x + b.x, y + b.y);
    }
    point operator-(point b)
    {
        return point(x - b.x, y - b.y);
    }
    void norm()
    {
        ld q = sqrtl(x * x + y * y);
        x /= q;
        y /= q;
    }
};

bool operator<(point a, point b)
{
    if (abs(a.x - b.x) < EPS)
    {
        return (a.y < b.y);
    }
    else
    {
        return (a.x < b.x);
    }
}

struct line
{
    ll a, b, c;
    line(ld q, ld w, ld e)
    {
        a = q;
        b = w;
        c = e;
    }
    line(point q, point w)
    {
        a = w.y - q.y;
        b = q.x - w.x;
        c = a * q.x + b * q.y;
        c *= -1;
    }
    line()
    {
        a = 0;
        b = 0;
        c = 0;
    }
    ld gety(ld x)
    {
        return (-(a * x + c) / b);
    }
    void norm()
    {
        ld x = sqrtl(a * a + b * b);
        a /= x;
        b /= x;
        c /= x;
        if (b < 0)
        {
            a *= -1;
            b *= -1;
            c *= -1;
        }
        if (a < 0)
        {
            a *= -1;
            b *= -1;
            c *= -1;
        }
    }
};

bool operator==(point a, point b)
{
    return (abs(a.x - b.x) < EPS && abs(a.y - b.y) < EPS);
}

line perp(point x, point v)
{
    return line(x, x + v);
}

ld dist(point a, point b)
{
    return sqrtl((a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y));
}

ll dist2(point a, point b)
{
    return ((a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y));
}

ld distpl(point a, line b)
{
    return (a.x * b.a + a.y * b.b + b.c) / sqrtl(b.a * b.a + b.b * b.b);
}

ld distnpl(point a, line b)
{
    return (a.x * b.a + a.y * b.b + b.c);
}

point operator*(point a, ld x)
{
    return point(a.x * x, a.y * x);
}

point h(point a, line b)
{
    b.norm();
    ld dist = distpl(a, b);
    point vec(b.a, b.b);
    vec = vec * dist;
    point ans = (a + vec);
    if (abs(distpl(ans, b)) < EPS)
    {
        return ans;
    }
    point vec1(-b.a, -b.b);
    vec1 = vec1 * dist;
    return (a + vec1);
}

vector<point> solve(point c, ld r, line l)
{
    l.norm();
    if (abs(distpl(c, l)) > r + EPS)
    {
        vector<point> answer;
        return answer;
    }
    if (abs(abs(distpl(c, l)) - r) < EPS)
    {
        point ans = h(c, l);
        vector<point> answer(1, ans);
        return answer;
    }
    point t = h(c, l);
    point vecl1(l.b, -l.a);
    point vecl2(-l.b, l.a);
    ld distnl = r * r - distpl(c, l) * distpl(c, l);
    distnl = sqrtl(distnl);
    point res1 = (vecl1 * distnl) + t;
    point res2 = (vecl2 * distnl) + t;
    vector<point> answer;
    answer.push_back(res1);
    answer.push_back(res2);
    return answer;
}

vector<point> solveokr(ld a, ld b, ld c, ld d, ld e, ld f)
{
    d -= a;
    e -= b;
    if (abs(d) < EPS && abs(e) < EPS && abs(f - c) < EPS)
    {
        return {point(1e16, 1e16)};
    }
    if (sqrtl(d * d + e * e) > f + c + EPS)
    {
        return {};
    }
    line l(-2 * d, -2 * e, d * d + e * e + c * c - f * f);
    if (abs(l.a) < EPS && abs(l.b) < EPS)
    {
        return {};
    }
    vector<point> answer = solve(point(0, 0), c, l);
    answer[0].x += a;
    answer[0].y += b;
    answer[1].x += a;
    answer[1].y += b;
    return answer;
}

point findis(line q, line w)
{
    point ans(-(q.c * w.b - q.b * w.c) / (q.a * w.b - w.a * q.b), -(w.c * q.a - q.c * w.a) / (w.b * q.a - q.b * w.a));
    return ans;
}

vector<point> tps(point c, ld r, ld px, ld py)
{
    ld a, b, d, e;
    a = c.x;
    b = c.y;
    d = px;
    e = py;
    // ld q = sqrtl((d - a) * (d - a) + (e - b) * (e - b));
    ld w = (d - a) * (d - a) + (e - b) * (e - b) - r * r;
    w = sqrtl(w);
    return solveokr(a, b, r, d, e, w);
}

int sign(ld x)
{
    if (abs(x) < EPS)
    {
        return 0;
    }
    if (x > 0)
    {
        return 1;
    }
    return -1;
}

ld polangle(point q)
{
    ld a = atan2(q.y, q.x);
    if (a < 0)
    {
        return a + 3.14159265358979323846 * (ld)2;
    }
    else
    {
        return a;
    }
}

ld scal(point a, point b)
{
    return (a.x * b.x + a.y * b.y);
}

ld pscal(point a, point b)
{
    return (a.x * b.y - a.y * b.x);
}

point findc(point a, point b, point c)
{
    line ab(a, b);
    line bc(b, c);
    line p1;
    p1.a = -ab.b;
    p1.b = ab.a;
    p1.c = ((a + b) * 0.5).x * p1.a + ((a + b) * 0.5).y * p1.b;
    p1.c *= -1;
    line p2;
    p2.a = -bc.b;
    p2.b = bc.a;
    p2.c = ((c + b) * 0.5).x * p2.a + ((c + b) * 0.5).y * p2.b;
    p2.c *= -1;
    point ans = findis(p1, p2);
    return ans;
}

line findserper(point a, point b)
{
    line ab(a, b);
    line p1;
    p1.a = -ab.b;
    p1.b = ab.a;
    p1.c = ((a + b) * 0.5).x * p1.a + ((a + b) * 0.5).y * p1.b;
    p1.c *= -1;
    return p1;
}

void operator>>(istream &in, point &x)
{
    in >> x.x >> x.y;
}

void operator<<(ostream &ou, point &x)
{
    ou << x.x << " " << x.y;
}

ld f2(ld a)
{
    return a * a;
}

bool angle_check(point o, point a, point b, point c)
{
    ld q1 = pscal(a - o, c - o);
    ld q2 = pscal(c - o, b - o);
    ld q3 = pscal(a - o, b - o);
    if (sign(q3) == 0)
        return false;
    if (sign(q1) == 0 || sign(q2) == 0)
    {
        return true;
    }
    if (sign(q1) == sign(q2) && sign(q2) == sign(q3))
    {
        return true;
    }
    return false;
}

bool pint(point x, point a, point b, point c)
{
    ld sall = abs(pscal(a - c, b - c));
    sall -= abs(pscal(a - x, b - x));
    sall -= abs(pscal(a - x, c - x));
    sall -= abs(pscal(c - x, b - x));
    if (abs(sall) < EPS)
    {
        return true;
    }
    return false;
}

point start;

/*bool comp(point a, point b) {
    a = a - start;
    b = b - start;
    ld a1 = atan2l(a.y, a.x), a2 = atan2l(b.y, b.x);
    if (abs(a1 - a2) < EPS) {
        return (dist(a, point(0, 0)) < dist(b, point(0, 0)));
    } else {
        return (a1 < a2);
    }
}*/

bool comp(point a, point b)
{
    a = a - start;
    b = b - start;
    if (sign(pscal(a, b)) == 0)
    {
        return (dist(a, point(0, 0)) < dist(b, point(0, 0)));
    }
    return (pscal(a, b) > 0);
}

vector<point> gr(vector<point> arr)
{
    int indminx = 0;
    for (int i = 0; i < arr.size(); ++i)
    {
        if (arr[i].y < arr[indminx].y || (abs(arr[i].y - arr[indminx].y) < EPS && arr[i].x < arr[indminx].x))
        {
            indminx = i;
        }
    }
    start = arr[indminx];
    sort(arr.begin(), arr.end(), comp);
    vector<point> st;
    for (int i = 0; i < arr.size(); ++i)
    {
        while (st.size() >= 2 && pscal(st[st.size() - 2] - st[st.size() - 1], arr[i] - st[st.size() - 1]) > -EPS)
        {
            st.pop_back();
        }
        st.push_back(arr[i]);
    }
    return st;
}

point operator/(point a, ld x)
{
    return point(a.x / x, a.y / x);
}

ld anglefromst(point a, point b)
{
    return atan2l(pscal(a, b), scal(a, b));
}

ld ssect(ld r, ld angle)
{
    return (r * r * angle / 2);
}

void ftl()
{
    int ans = 0;
    for (int i = 0; i < 10100000; ++i)
    {
        ans += i * i * cos(i);
    }
    cerr << ans;
}

int getlg(ll a)
{
    int ans = 0;
    for (int i = 0; i < 100; ++i)
    {
        if (a >= (1ll << i))
        {
            ans = i;
        }
        else
        {
            break;
        }
    }
    return ans;
}

void slv()
{
    string s;
    cin >> s;
    for (int i = 0; i < 8; ++i)
    {
        int ind = i * 7;
        bool flag = true;
        ind += s[0] - 'A';
        if (ind > 51 || ind < 0)
        {
            flag = false;
        }
        for (int j = 1; j < s.size(); ++j)
        {
            int tmp = s[j] - s[j - 1];
            if (tmp > 3)
            {
                tmp -= 7;
            }
            else if (tmp < -3)
            {
                tmp += 7;
            }
            ind += tmp;
            if (ind > 51 || ind < 0)
            {
                flag = false;
                break;
            }
        }
        if (flag)
        {
            cout << "YES";
            return;
        }
    }
    cout << "NO";
}

int main()
{
    cin.tie(0);
    cout.tie(0);
    ios_base::sync_with_stdio(false);
    int _;
    cin >> _;
    while (_--)
    {
        slv();
        cout << "\n";
    }
    return 0;
}
/*

*/