#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

const int MOD = 1e9 + 7;

long long mod_pow(long long a, long long b, int mod) {
    long long r = 1;
    while (b) {
        if (b & 1) r = r * a % mod;
        a = a * a % mod;
        b >>= 1;
    }
    return r;
}

void precompute_factorials(int n, vector<long long> &fact, vector<long long> &inv_fact, vector<long long> &inv) {
    fact.resize(n+1);
    inv_fact.resize(n+1);
    inv.resize(n+1);
    fact[0] = 1;
    for (int i = 1; i <= n; i++) {
        fact[i] = fact[i-1] * i % MOD;
    }
    inv_fact[n] = mod_pow(fact[n], MOD-2, MOD);
    for (int i = n-1; i >= 0; i--) {
        inv_fact[i] = inv_fact[i+1] * (i+1) % MOD;
    }
    inv[1] = 1;
    for (int i = 2; i <= n; i++) {
        inv[i] = (MOD - MOD/i) * inv[MOD % i] % MOD;
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    
    int z;
    cin >> z;
    vector<pair<int, int>> tests(z);
    int max_n = 0;
    for (int i = 0; i < z; i++) {
        int p, m;
        cin >> p >> m;
        tests[i] = {p, m};
        int n = 2 * p + m;
        if (n > max_n) max_n = n;
    }
    
    vector<long long> fact, inv_fact, inv;
    precompute_factorials(max_n, fact, inv_fact, inv);
    
    for (auto &test : tests) {
        int p = test.first, m = test.second;
        int n = 2 * p + m;
        
        long long a0 = 1;
        long long a1 = (2LL * p + m) % MOD;
        
        long long P = fact[n];
        P = (P + fact[1] * fact[n-1] % MOD * a1) % MOD;
        
        long long ap = a0;
        long long ac = a1;
        for (int i = 1; i <= n-2; i++) {
            long long term1 = (2LL * p + m - 3LL * i) % MOD;
            if (term1 < 0) term1 += MOD;
            term1 = term1 * ac % MOD;
            
            long long term2 = (2LL * p + 2LL * m - 2LL * i + 2) % MOD;
            if (term2 < 0) term2 += MOD;
            term2 = term2 * ap % MOD;
            
            long long an = (term1 + term2) % MOD;
            an = an * inv[i+1] % MOD;
            
            P = (P + fact[i+1] * fact[n - i - 1] % MOD * an) % MOD;
            
            ap = ac;
            ac = an;
        }
        
        long long E = P * inv_fact[n] % MOD;
        cout << E << '\n';
    }
    
    return 0;
}