import random
import sys


values = set()
def do_colatz(n, step = 0):
    if step > 62:
        return
    if n >= 10 ** 12:
        return
    if n in values:
        return
    values.add(n)
    do_colatz(n * 2, step + 1)
    if ((n - 1) % 3 == 0) and n != 1:
        do_colatz((n - 1) // 3, step + 1)


import time
begin = time.time()
do_colatz(1)
end = time.time()
print(end - begin)
print(len(values))

n = int(input())

for _ in range(n):
    while True:
        number = int(input())
        if number == 0:
            sys.exit(0)
        if number == 1:
            break
        if number % 2 == 0:
            print('collatz')
        elif ((number * 3) + 1) % 4 == 0:
            print('collatz')
        elif ((number * 3 + 1) * 3 + 1) % 16 == 0:
            print('collatz')
        elif number in values:
            print('collatz')
        else:
            print('RANDOM')