// #ifndef debug
// #define debug
// #endif

#include <bits/stdc++.h>

#define i32 int32_t
#define u32 uint32_t
#define i64 int64_t
#define u64 uint64_t
#define u128 __uint128_t

#define int int64_t
#define uint uint64_t
#define F first
#define S second
#define pii pair<int, int>
#define piii tuple<int, int, int>
#define pb push_back
#define eb emplace_back
#define ld long double
#define all(a) a.begin(), a.end()
#define reverse_all(a) reverse(a.begin(), a.end())

constexpr double pi = 3.14159265358979323846;

constexpr int64_t operator"" _i(unsigned long long value) {
  return static_cast<int64_t>(value);
}

constexpr uint64_t operator"" _u(unsigned long long value) {
  return static_cast<uint64_t>(value);
}

using namespace std;

// Graph structure
template <typename T> using graph = vector<vector<T>>;

const int INF = 1e18 + 1234567;
const int MOD = 1e9 + 7;
const int mod = 998244353;
const double inf = 2e9 + 1;
const int LIM = 1e9;
const double EPS = 1e-9;
mt19937_64
    gen(chrono::high_resolution_clock().now().time_since_epoch().count());

#define INDEX(a, ptr) (int)(ptr - a.begin())
#define DB(x) cout << #x << '=' << x << '\n';

std::pair<int, int> &operator+=(std::pair<int, int> &lhs,
                                const std::pair<int, int> &rhs) {
  lhs = {lhs.first + rhs.first, lhs.second + rhs.second};
  return lhs;
}

std::pair<int, int> &operator-=(std::pair<int, int> &lhs,
                                const std::pair<int, int> &rhs) {
  lhs = {lhs.first - rhs.first, lhs.second - rhs.second};
  return lhs;
}

int bin_pow_mod(int a, int p, int m) {
  int res = 1;
  while (p > 0) {
    if (p % 2) {
      res = res * a % m;
    }
    a = a * a % m;
    p >>= 1;
  }
  return res;
}

int gcd(int a, int b, int &x, int &y) {
  if (a == 0) {
    x = 0;
    y = 1;
    return b;
  }

  int x1, y1;
  int d = gcd(b % a, a, x1, y1);
  x = y1 - (b / a) * x1;
  y = x1;
  return d;
}

int ceil_sqrt(int n) {
  assert(n >= 0);
  int l = -1, r = n;
  while (r - l > 1) {
    int mid = (l + r) / 2;
    if (mid * mid < n)
      l = mid;
    else
      r = mid;
  }
  return r;
}

template <typename T> class trie_t {
  struct node_t {
    i32 to[2] = {0, 0};
    i32 end = 0;
  };

  std::vector<node_t> data;

  // bool can_go(int v, T c) { return data[v].to.count(c); }

  bool can_go(int v, T c) { return data[v].to[c]; }

  i32 &go(int v, T c) { return data[v].to[c]; }

  int create_node() {
    data.push_back(node_t());
    return data.size() - 1;
  }

  int is_end(int v) { return data[v].end; }

public:
  trie_t() { create_node(); }

  int search(const string &s) {
    int v = 0;
    for (auto c : s) {
      if (!can_go(v, c))
        return 0;
      v = go(v, c);
    }
    return data[v].end;
  }

  void insert(const string &s) {
    int v = 0;
    for (auto c : s) {
      if (!can_go(v, c))
        go(v, c) = create_node();
      v = go(v, c);
    }
    data[v].end++;
  }

  void insert(int s) {
    int v = 0;
    for (int i = 0; i < 30; i++) {
      bool c = s & (1 << (29 - i));
      if (!can_go(v, c))
        go(v, c) = create_node();
      v = go(v, c);
    }
    data[v].end++;
  }

  void erase(const string &s) {
    int v = 0;
    for (auto c : s) {
      if (!can_go(v, c))
        return;
      v = go(v, c);
    }
    data[v].end = std::max(0_i, data[v].end - 1);
  }

  int find_max_xor(int s) {
    int v = 0, result = 0;
    for (int i = 0; i < 30; i++) {
      bool c = s & (1 << (29 - i));
      if (can_go(v, !c)) {
        v = go(v, !c);
        result += (1 << (29 - i));
      } else {
        v = go(v, c);
      }
    }
    return result;
  }
};

void solve() {
  int t;
  cin >> t;

  int n;
  cin >> n;
  vector<int> a(n);
  for (auto &t : a) cin >> t;

  if (!t) {
      int s = 0;
      for (int i = 0;i < n;i++) s = (s + a[i]) % n;
      cout << s + 1 << endl;
  } else {
      t--;
      int s = 0;
      for (int i = 0;i < n;i++) {
        s = (s + a[i]) % (n + 1);
      }

      if (t == s) {
        cout << n + 1 << endl;
      }
      else if (t > s) {
        cout << t - s << endl;
      }
      else {
        cout << n + 1 + t - s << endl;
      }
  }
}

int32_t main() {
#ifdef debug
  auto _input = freopen("input.txt", "r", stdin);
  auto _output = freopen("output.txt", "w", stdout);
#endif
  ios_base::sync_with_stdio(0);
  cin.tie(0);
  cout.tie(0);
  cout.precision(10);

  // precalc();

  int t = 1;
  // cin >> t;
  while (t--) {
    solve();
    cout << "\n";
  }
  return 0;
}