#include <bits/stdc++.h>
using namespace std;

template <typename T>
struct Line
{
    T a = 0, b = 0, c = 0;
    Line() = default;
    Line(T aa, T bb, T cc): a(aa), b(bb), c(cc) {};
};

template <typename T>
struct Point
{
    T x = 0, y = 0;
    Point() = default;
    Point(T xx, T yy): x(xx), y(yy) {};
    long long dist_to(Point<T> to)
    {
        T dx = x - to.x, dy = y - to.y;
        return (dx * dx + dy * dy);
    }
    bool operator < (Point<T> b)
    {
        return (x < b.x || (x == b.x && y < b.y));
    }
    Point<T> operator + (Point<T> b)
    {
        return {x + b.x, y + b.y};
    }
    Point<T> operator - (Point<T> b)
    {
        return {x - b.x, y - b.y};
    }
    T operator ^ (Point<T> b)
    {
        return (x * b.y) - (y * b.x);
    }
    Line<T> make_line(Point<T> b)
    {
        return {y - b.y, b.x - x, -(x * (y - b.y) + y * (b.x - x))};
    }
};

template <typename T>
struct Vector
{
    T x = 0, y = 0;
    Vector() = default;
    Vector(T xx, T yy): x(xx), y(yy) {};
    Vector(Point<T> s, Point<T> f)
    {
        x = f.x - s.x;
        y = f.y - s.y;
    }
    T dot_product(Vector<T> B)
    {
        return (x * B.x) + (y * B.y);
    }
    T cross_product(Vector<T> B)
    {
        return (x * B.y) - (y * B.x);
    }
};

vector<Point<int>> G(vector<Point<int>> &a)
{
    int n = a.size();
    int first = 0;
    for (int i = 1; i < n; ++i)
    {
        if (a[i].x < a[first].x)
        {
            first = i;
        }
        else if (a[i].x == a[first].x && a[i].y < a[first].y)
        {
            first = i;
        }
    }
    Point<int> ans1 = a[first];
    for (int i = 0; i < n; ++i)
    {
        a[i] = a[i] - ans1;
    }
    sort(a.begin(), a.end(), [&](Point<int> a, Point<int> b)
         {    return ((a ^ b) > 0 ||
                     ((a ^ b) == 0 && a.x * a.x + a.y * a.y > b.x * b.x + b.y * b.y)); });
    vector<Point<int>> ans;
    for (auto point: a)
    {
        while (ans.size() >= 2 && (((point - ans.back()) ^ (ans[ans.size() - 2] - ans.back())) <= 0))
        {
            ans.pop_back();
        }
        ans.push_back(point);
    }
    for (int i = 0; i < ans.size(); ++i)
    {
        ans[i] = ans[i] + ans1;
    }
    return ans;
}

template <typename T>
istream& operator>>(istream& in, Point<T> &A)
{
    return in >> A.x >> A.y;
}

template <typename T>
ostream& operator<<(ostream& out, Point<T> A)
{
    return out << A.x << ' ' << A.y;
}

template <typename T>
ostream& operator<<(ostream& out, Line<T> A)
{
    return out << A.a << ' ' << A.b << ' ' << A.c;
}

signed main()
{
    int n;
    cin >> n;
    vector<Point<int>> a(n);
    for (int i = 0; i < n; ++i)
    {
        cin >> a[i];
    }
    vector<Point<int>> v = G(a);
    int m = v.size();
    for (int i = 0; i < m; ++i)
    {
        v.push_back(v[i]);
    }
    m *= 2;
    int r = 0;
    long long mx = 0;
    Point<int> p1, p2;
    for (int l = 0; l < m; ++l)
    {
        r = max(r, l);
        while (r < m && v[l].dist_to(v[r + 1]) > v[l].dist_to(v[r]))
        {
            if (mx < v[l].dist_to(v[r]))
            {
                mx = v[l].dist_to(v[r]);
                p1 = v[l];
                p2 = v[r];
            }
            ++r;
        }
//        cout << l << ' ' << r << '\n';
        if (r < m && mx < v[l].dist_to(v[r]))
        {
            mx = v[l].dist_to(v[r]);
            p1 = v[l];
            p2 = v[r];
        }
    }
//    cout << p1 << ' ' << p2 << '\n';
    Line<int> l = p1.make_line(p2);
//    cout << l << '\n';
    Line<int> ans1 = {-l.b, l.a, l.c};
    ans1.c = -(p1.x * ans1.a + p1.y * ans1.b);
    Line<int> ans2 = {-l.b, l.a, l.c};
    ans2.c = -(p2.x * ans2.a + p2.y * ans2.b);
    cout << ans1 << '\n' << ans2;
}
