
#include <iostream>
#include <map>
#include <string>

using namespace std;

typedef long long ll;
typedef long double ld;

struct coord {
    ll x, y;

    bool operator<(const coord& other) const
    {
        return x < other.x || x == other.x && y < other.y;
    }

    bool operator==(const coord& other) const
    {
        return x == other.x && y == other.y;
    }
};

struct mat {
    ll x, y, z, t;
};

int main() {
    ll n;
    cin >> n;
    ll s = (3*n-2)*(n-1)+2*n-1;
    auto coords = map<coord, ll>();
    auto numbers = new ll[s];

    ll row = n, cur = 0, x = 0, y = 1-n, delta = 1;
    for (ll i = 0; i < s; i++)
    {
        coords[{x,y}] = i;
//        cout << x << " " << y << endl;
        cin >> numbers[i];
        x++;
        y++;
        cur++;
        if (cur == row)
        {
            if (row == 2*n-1) delta = -1;
            if (delta == 1) x--;
            else y++;
            x -= row;
            y -= row;
            row += delta;
            cur = 0;
        }
    }

    string ops;
    cin >> ops;
    mat m { 1, 0, 0, 1 };
    for (auto c : ops) {
        if (c == 'T') m = { -m.z, -m.t, -m.x, -m.y };
        if (c == 'L') m = { m.x+m.z, m.y+m.t, -m.x, -m.y };
        if (c == 'R') m = { -m.z, -m.t, m.x+m.z, m.y+m.t };
//        cout << m.x << " " << m.y << " " << m.z << " " << m.t << endl;
    }

    row = n; cur = 0; x = 0; y = 1-n; delta = 1;
    for (ll i = 0; i < s; i++)
    {
//        cout << x << " " << y << " --> " << x*m.x+y*m.z<<" "<<x*m.y+y*m.t << endl;
//        cout << coords[{x*m.x+y*m.z,x*m.y+y*m.t}] << endl;
        cout << numbers[coords[{x*m.x+y*m.z,x*m.y+y*m.t}]] << " ";
        x++;
        y++;
        cur++;
        if (cur == row)
        {
            if (row == 2*n-1) delta = -1;
            if (delta == 1) x--;
            else y++;
            x -= row;
            y -= row;
            row += delta;
            cur = 0;
            cout << endl;
        }
    }

    return 0;
}
