#pragma gcc optimize("Ofast")

#include <iostream>
#include <algorithm>
#include <vector>
#include <iomanip>
#include <map>
#include <set>
#include <fstream>
#include <string>
#include <bitset>
#include <ctime>
#include <random>
#include <iterator>
#include <cmath>
#include <queue>
#include <deque>
#include <time.h>
 
using namespace std;
 
#define all(a) a.begin(), a.end()
#define rsort(a) sort(a, [&](auto b, auto c) {return b > c;})
 
ifstream fin("input.txt");
ofstream fout("output.txt");
 
using ll = long long;
using ld = long double;
using ull = unsigned long long;
 
ll const inf = 1e18;
 
template <class T>
istream& operator>> (istream& in, vector<T>& a)
{
	for (T& e : a)
		in >> e;
	return in;
}
 
template <class T>
ostream& operator<< (ostream& out, const vector<T>& a)
{
	for (const T& e : a)
		out << e << " ";
	return out;
}
 
template<class T, class N> auto min(T a, N b)
{
	return sizeof(a) > sizeof(b) ? min(a, (T)b) : min((N)a, b);
}
 
template<class T, class N> auto max(T a, N b)
{
	return sizeof(a) > sizeof(b) ? max(a, (T)b) : max((N)a, b);
}
 
const ll MOD = 998244353;

ll true_mod(ll a, ll m) {
	if (m < 0) {
		m *= -1;
	}
	return ((a % m) + m) % m;
}

ll true_div(ll a, ll m) {
	return (a - true_mod(a , m)) / m;
}
 
ll bin_pow_mod(ll a, ll n)
{
	ll res = 1;
	while (n)
	{
		if (n & 1)
		{
			res *= a;
			res %= MOD;
		}
 
		n >>= 1;
		a *= a;
		a %= MOD;
	}
 
	return res;
}
 
ll bin_pow(ll a, ll n)
{
	ll res = 1;
	while (n)
	{
		if (n & 1)
		{
			res *= a;
		}
 
		n >>= 1;
		a *= a;
	}
 
	return res;
}
 
ll gcd(ll a, ll b)
{
	while (b)
	{
		a %= b;
		swap(a, b);
	}
	return a;
}
 
random_device rd;
mt19937 mersenne(rd());

void solve();
 
// #define TIME
#define ONCE
 
signed main()
{
	ios::sync_with_stdio(false);
	cin.tie(0);
	cout.tie(0);
 
	ll TT = 1;
#ifndef ONCE 
	cin >> TT;
#endif
	while (TT--)
	{
#ifdef TIME
		clock_t start, end;
 
		start = clock();
#endif
		solve();
#ifdef TIME
		end = clock();
 
		cerr << "\ntime: " << ((double)end - start) / ((double)CLOCKS_PER_SEC) << " s\n";
#endif
		cerr << '\n';
	}
	return 0;
}

ll reverse(ll n)
{
	vector<ll> bits;
	while (n)
	{
		bits.push_back(n % 2);
		n /= 2;
	}
	ll k = 0;
	for (auto bit : bits)
	{
		k *= 2;
		k += bit;
	}
	return k;
}

bool lucky(ll a, ll b)
{
	ll a1 = a / 10;
	ll a2 = a % 10;
	ll b1 = b / 10;
	ll b2 = b % 10;

	if (a2 == 2 && b1 == 3 && b2 == 9)
	{
		return true;
	}
	if (a1 == 2 && (set({0,2,3}).count(a2)) && b1 == 3 && b2 == 9)
	{
		return true;
	}
	if (a1 == 2 && a2 == 3 && (set({0,3,9}).count(b1)) && b2 == 9)
	{
		return true;
	}

	if (a1 == 2 && a2 == 3 && b1 == 9)
	{
		return true;
	}

	return false;
}

void solve() 
{
	ll H, M;
	cin >> H >> M;

	ll cnt = 0;

	for (int a = 0; a < H; ++a)
	{
		for (int b = 0; b < M; ++b)
		{
			if (lucky(a,b))
			{
				++cnt;
			}
		}
	}

	cout << cnt << '\n';

}
