// semenInRussia 2024
#include <algorithm>
#include <iomanip>
#include <iostream>
#define _USE_MATH_DEFINES
#include <cmath>
using namespace std;

using T = long long;
using P = pair<T, T>;

istream &operator>>(istream &in, P &v) { return in >> v.first >> v.second; }

T sq(P a) { return a.first * a.first + a.second * a.second; }
T abs(P a) { return sqrt(sq(a)); }
P operator-(P a, P b) { return {a.first - b.first, a.second - b.second}; }
T dist(P a, P b) { return abs(a - b); }
P perp(P p) { return {-p.second, p.first}; }
T cross(P a, P b) { return a.first * b.second - a.second * b.first; }

const int N = 2e5;
P a[N];

int convex(P a[N], int n) {
  for (int i = 0; i < n; i++) {
    if (a[i] < a[0]) {
      swap(a[i], a[0]);
    }
  }

  P a0 = a[0];

  sort(a, a + n, [a0](P x, P y) {
    P s = x - a0;
    P t = y - a0;
    T f = cross(s, t);
    if (f == 0) {
      return sq(s) < sq(t);
    }
    return f > 0;
  });

  int h = 2;
  for (int i = 2; i < n; i++) {
    while (h >= 2) {
      auto x = a[i] - a[h - 1];
      auto y = a[h - 1] - a[h - 2];
      if (cross(x, y) >= 0) {
        h--;
      } else {
        break;
      }
    }
    swap(a[h], a[i]);
    h++;
  }

  return h;
}

struct line {
  P v;
  T c;

  line(P a, P b) : v(b - a), c(cross(v, a)) {}
  T side(P p) { return cross(v, p) - c; }
  T dist(P p) { return abs(side(p)) / abs(v); }
  T dist2(P p) { return side(p) * side(p) / (T)sq(v); }
};

int main() {
  cin.tie(nullptr)->sync_with_stdio(false);
  int n;
  cin >> n;
  for (int i = 0; i < n; i++) {
    cin >> a[i];
  }

  if (n == 2) {
    cout << "0 0 0\n";
    cout << "0 0 0\n";
    return 0;
  }

  n = convex(a, n);

  pair<T, pair<int, int>> ans = {0, {0, 0}};

  for (int i = 0; i < n; i++) {
    // line ab(a[i], a[(i + 1) % n]);
    for (int j = 0; j < n; j++) {
      // side(p) * side(p) / (T)sq(v)
      ans = max(ans, {sq(a[j] - a[i]), {i, j}});
    }
  }

  auto [i, j] = ans.second;
  P u = a[i] - a[j];
  P v = perp(u);

  cout << -v.second << ' ' << v.first << ' ' << -cross(v, a[i]) << "\n";
  cout << -v.second << ' ' << v.first << ' ' << -cross(v, a[j]) << "\n";
}
