#include <bits/stdc++.h>

using namespace std;

typedef long long ll;

const ll INF = 1e18;

void Fast() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
}

pair<int, pair<int, int>> rotate(pair<int, pair<int, int>> pos, int k) {
    int x = pos.first;
    int y = pos.second.first;
    int z = pos.second.second;
    while (k--) {
        int to_x = -z;
        int to_y = -x;
        int to_z = -y;
        x = to_x;
        y = to_y;
        z = to_z;
    }

    return {x, {y, z}};
}

signed main() {
    Fast();

    int n;
    cin >> n;

    vector<vector<int>> gex;
    for (int i = 0; i < 2 * n - 1; ++i) {
        gex.emplace_back();
        gex.back().resize(n - abs(i - (n - 1)) + (n - 1));
        for (auto &v: gex.back()) cin >> v;
    }

    string s;
    cin >> s;

    int sym = 0, rot = 0;
    for (auto c: s) {
        if (c == 'R' && sym == 0 || c == 'L' && sym == 1) {
            rot = (rot + 1) % 6;
        } else if (c == 'R' && sym == 1 || c == 'L' && sym == 0) {
            rot = (rot + 5) % 6;
        } else {
            sym = 1 - sym;
        }
    }

    map<pair<int, pair<int, int>>, int> bij;

    int rad = n - 1;

    for (int r = -rad, i = 0; r <= rad; ++r, ++i) {
        int mn = max(-rad, -(r + rad));
        int mx = min(rad, rad - r);
        for (int s = mn, j = 0; s <= mx; ++s, ++j) {
            int x = s;
            int z = r;
            int y = -(x + z);

            bij[rotate({x, {y, z}}, rot)] = gex[i][j];
        }
    }

    vector<vector<int>> out;
    for (int r = -rad, i = 0; r <= rad; ++r, ++i) {
        out.emplace_back();

        int mn = max(-rad, -(r + rad));
        int mx = min(rad, rad - r);

        for (int s = mn, j = 0; s <= mx; ++s, ++j) {
            int x = s;
            int z = r;
            int y = -(x + z);

            out.back().push_back(bij[{x, {y, z}}]);
        }
    }

    if (sym == 1) {
        for (auto &row: out) {
            int sz = (int) row.size();
            for (int i = 0; i < sz / 2; ++i) {
                swap(row[i], row[sz - i - 1]);
            }
        }
    }

    for (auto &row: out) {
        for (auto v: row) {
            cout << v << ' ';
        }
        cout << '\n';
    }

    return 0;
}
