﻿#include <iostream>
#include <bitset>

const int MAX_BITS = 2000000;

int main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(nullptr);

    int n;
    std::cin >> n;

    long long vl;
    std::cin >> vl;

    const long long M = 999983;
    std::bitset<MAX_BITS> V;
    std::bitset<MAX_BITS> G;

    for (int i = 0; i < n; i++) {
        vl = (vl * 618023 + 1) % M;

        if (!G.test(vl))
        {
            for (size_t pos = V._Find_first(); pos != V.size(); pos = V._Find_next(pos))
            {
                if (pos + vl < MAX_BITS) G.flip(pos + vl);
            }

            if (2 * vl < MAX_BITS) G.flip(2 * vl);

            V.set(vl);
        }
    }

    std::cout << V.count() << std::endl;
    return 0;
}
