from functools import cache
from sys import stdout

@cache
def collatz(x):
    if x == 1:
        return (1, 0)
    base_cost = len(str(x))
    if x % 2 == 0:
        a = collatz(x // 2)
    else:
        a = collatz(3 * x + 1)
    return (base_cost + a[0], a[1] + 1)


def do_n(n: int):
    for _ in range(n):
        input("collatz\n")
        stdout.flush()


def game():
    x = int(input())
    if x == 0:
        exit(0)
    if x == 1:
        return
    cost = collatz(x)
    if cost[0] >= 580:
        print("random\n")
        stdout.flush()
        game()
        return
    do_n(cost[1])
    pass    


t = int(input())
for _ in range(t):
    game()
