#include <bits/stdc++.h>
using namespace std;

int get_row_length(int n, int i) {
    return n + min(i, (2 * n - 1) - 1 - i);
}

void T(vector<vector<int>>& mx){
    for(auto& v : mx){
        reverse(v.begin(), v.end());
    }
}

vector<vector<int>> L(const vector<vector<int>>& mx, int n){
    vector<vector<int>> mx_copy = mx;

    T(mx_copy);

    vector<vector<int>> new_mx(2*n - 1);

    for (int i = 0; i < 2 * n - 1; i++) {
        new_mx[i].reserve(get_row_length(n, i));
    }

    int delta = 0;
    for(int i = 0; i < 2*n - 1; i++){
        if(i >= n) delta++;
        for(int j = 0; j < mx_copy[i].size(); j++){
            new_mx[j + delta].push_back(mx_copy[i][j]);
        }
    }
    return new_mx;
}

void R(vector<vector<int>> &mx, int n)
{
    T(mx);
    mx = L(mx, n);
    T(mx);
}

void print_sex(const vector<vector<int>> &mx, int n)
{
    int max_cells = 2 * n - 1;
    for (const vector<int> &row : mx)
    {
        int row_len = row.size();
        int leading_spaces = (max_cells - row_len);

        for(int s = 0; s < leading_spaces; ++s) cout << ' ';

        for (size_t j = 0; j < row.size(); ++j)
        {
            cout << row[j] << (j == row.size() - 1 ? "" : " ");
        }

        for(int s = 0; s < leading_spaces; ++s) cout << ' ';

        cout << "\n";
    }
}


int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n; cin >> n;

    vector<vector<int>> mx(2*n - 1);
    int max_cells = 2 * n - 1;

    for(int i = 0; i < max_cells; i++){
        int current_line_length = get_row_length(n, i);

        mx[i].reserve(current_line_length);

        for(int j = 0; j < current_line_length; j++){
            int x; cin >> x;
            mx[i].push_back(x);
        }
    }

    string str;

    cin >> str;

    for(auto& ch : str){
        if(ch == 'L'){
            mx = L(mx, n);
        } else if(ch == 'R'){
            R(mx, n);
        } else T(mx);
    }

    print_sex(mx, n);

    return 0;
}
