#include <iostream>
#include <vector>
using namespace std;

using u64 = unsigned long long;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    const int P = 999983;         
    const u64 Acoef = 618023;
    const u64 C = 1;

    long long n, s;
    if (!(cin >> n >> s)) return 0;

    const int W = 64;
    const int NWORDS = (P + W - 1) / W;

    vector<u64> A(NWORDS, 0), R(NWORDS, 0);

    auto getBit = [&](int pos) -> int {
        return (A[pos >> 6] >> (pos & 63)) & 1ULL;
    };
    auto setBit = [&](int pos) -> bool {
        int w = pos >> 6, b = pos & 63;
        u64 mask = 1ULL << b;
        if (A[w] & mask) return false;
        A[w] |= mask;
        int rpos = P - 1 - pos;
        R[rpos >> 6] |= (1ULL << (rpos & 63));
        return true;
    };

    auto w_mod4 = [&](int s_val) -> unsigned {
        int k = (P - 1 - s_val);
        int q = k >> 6;
        int off = k & 63;

        unsigned sum4 = 0;
        for (int i = 0; i < NWORDS; ++i) {
            u64 av = A[i];
            if (!av) continue;

            u64 br = 0;
            int j0 = i + q;
            if (j0 >= 0 && j0 < NWORDS) br |= (R[j0] >> off);
            if (off) {
                int j1 = j0 + 1;
                if (j1 >= 0 && j1 < NWORDS) br |= (R[j1] << (64 - off));
            }

            u64 inter = av & br;
            sum4 += (__builtin_popcountll(inter) & 3u);
            sum4 &= 3u;
        }
        return sum4;
    };

    size_t setSize = 0;

    for (long long step = 0; step < n; ++step) {
        s = ( ( (__int128)s * Acoef ) + C ) % P;

        int D = 0;
        if ((s & 1LL) == 0) D = getBit((int)(s >> 1));

        unsigned w4 = w_mod4((int)s);
        int halfBit = (w4 >> 1) & 1;
        int U_parity = halfBit ^ D;

        if (U_parity == 0) {
            if (setBit((int)s)) ++setSize;
        }
    }

    cout << setSize << '\n';
    return 0;
}

