#include <iostream>
#include <string>
using namespace std;


static inline unsigned mod_pow2(const string& s, int K) {
    unsigned mask = (1u << K) - 1u, r = 0;
    for (char c : s) r = ((r * 10u) + unsigned(c - '0')) & mask;
    return r;
}

static inline int v2_of_3x1_mod2K(unsigned m, int K) {
    unsigned y = 3u * m + 1u;
    int k = 0;
    while ((y & 1u) == 0u && k < K) { y >>= 1; ++k; }
    return k;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t; 
    if (!(cin >> t)) return 0;

    const int K = 12;      
    const int RANDOM_CAP = 3;
    const int LEN_CAP = 19;  

    for (int round = 0; round < t; ++round) {
        string x;
        cin >> x;
        if (x == "0") return 0;

        int consecRandom = 0;

        while (x != "1") {
            if (x == "0") return 0;

            bool even = ((x.back() - '0') % 2 == 0);
            bool useRandom = false;

            if (!even) {
        
                unsigned m = mod_pow2(x, K);
                int k = v2_of_3x1_mod2K(m, K);
                if (k <= 2 && consecRandom < RANDOM_CAP && (int)x.size() < LEN_CAP) {
                    useRandom = true;
                }
            }

            if (even || !useRandom) {
                cout << "collatz\n" << flush;
                consecRandom = 0;
            } else {
                cout << "random\n" << flush;
                ++consecRandom;
            }

            if (!(cin >> x)) return 0;
            if (x == "0") return 0;
        }
    }
    return 0;
}
