#include <iostream>
#include <string>
#include <vector>
#include <cstdint>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr); 

    constexpr int W = 52;
    constexpr uint64_t ALL = (W == 64) ? ~0ULL : ((1ULL << W) - 1ULL);

    uint64_t maskByLetter[7] = {0};
    for (int i = 0; i < W; ++i) maskByLetter[i % 7] |= (1ULL << i);

    int T;
    if (!(cin >> T)) return 0;

    vector<char> ans;
    ans.reserve(T);

    for (int tc = 0; tc < T; ++tc) {
        string s; 
        cin >> s;

        uint64_t cur = maskByLetter[s[0] - 'A'];
        for (size_t i = 1; i < s.size() && cur; ++i) {
            uint64_t reach = cur;
            reach |= ((cur << 1) & ALL) | (cur >> 1);
            reach |= ((cur << 2) & ALL) | (cur >> 2);
            reach |= ((cur << 3) & ALL) | (cur >> 3);
            cur = reach & maskByLetter[s[i] - 'A'];
        }
        ans.push_back(cur ? 1 : 0);
    }

    for (char ok : ans) {
        cout << (ok ? "YES" : "NO") << '\n';
    }
    return 0;
}
