#include <iostream>
#include <vector>
#include <cmath>
#include <set>
#include <deque>

#define USE_MATH_DEFINES

using namespace std;

typedef long long ll;
typedef long double ld;

const ll mod = 1000000007;

ll bin_pow(ll a, ll n) {
    if (n == 0) {
        return 1;
    } else if (n % 2 == 1) {
        return a * bin_pow(a, n - 1) % mod;
    } else {
        ll b = bin_pow(a, n / 2);
        return b * b % mod;
    }
}

struct point{
    ll x, y;
};

ll dist(point a, point b) {
    return (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y);
}

int cnt[1000000];

void solve() {
    ll n, s; cin >> n >> s;
    for (int i = 0; i < 1000000; i++) {
        cnt[i] = 0;
    }
    set<int> x;
    for (int i = 0; i < n; i++) {
        s = (s * 618023 + 1) % 999983;
        ll cnt_p = 0;
        for (auto j : x) {
            if (j > s) {
                break;
            }
            cnt_p += 1ll * cnt[j] * cnt[s - j];
        }
        cnt_p /= 2;
        if (cnt_p % 2 == 0) {
            cnt[s]++;
            x.insert(s);
        }
    }
    int ans = 0;
    for (int i = 0; i < 1000000; i++) {
        ans += cnt[i];
    }
    cout << ans;
}

int main() {
#ifdef LOCAL
    freopen("input.txt", "r", stdin);
    freopen("output.txt", "w", stdout);
#endif
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    int t = 1;
    // cin >> t;
    while (t--) {
        solve();
    }
    return 0;
}