#include <bits/stdc++.h>
#include <iostream>

#define all(a) a.begin(), a.end()

using namespace std;
using ll = long long;

const ll INF = 1e18;

map<char, vector<ll>> piano = {{'A', {1, 8, 15, 22, 29, 36, 43, 50}},
                               {'B', {2, 9, 16, 23, 30, 37, 44, 51}},
                               {'C', {3, 10, 17, 24, 31, 38, 45, 52}},
                               {'D', {4, 11, 18, 25, 32, 39, 46}},
                               {'E', {5, 12, 19, 26, 33, 40, 47}},
                               {'F', {6, 13, 20, 27, 34, 41, 48}},
                               {'G', {7, 14, 21, 28, 35, 42, 49}}};

string ppiano = "ABCDEFGABCDEFGABCDEFGABCDEFGABCDEFGABCDEFGABCDEFGABC";
ll pianolen = ppiano.length();

bool is_real(string melody, ll point, ll curridx) {
  if (curridx < 0 || curridx >= pianolen || ppiano[curridx] != melody[point]) {
    return false;
  }
  cout << point << ":" << melody[point] << " " << curridx << ":" << ppiano[curridx] << endl;
  if (point == melody.length() - 1 && ppiano[curridx] == melody[point]) {
    return true;
  }
  bool ans = false;
  for (int i = curridx - 3; i <= curridx + 3; i++) {
    ans |= is_real(melody, point + 1, i);
  }
  return ans;
}

void solve() {
  string s;
  cin >> s;
  for (auto start : piano[s[0]]) {
    if (is_real(s, 0, start - 1)) {
      cout << "YES" << endl;
      return;
    }
  }
  cout << "NO" << endl;
}

int main() {
  ios::sync_with_stdio(false);
  cin.tie(nullptr);
  cout.tie(nullptr);

  if (fopen("input.txt", "r")) {
    freopen("input.txt", "r", stdin);
  }

  ll t = 1;
  cin >> t;
  while (t--) {
    solve();
  }
}
