#include <iostream>
#include <vector>
#include <algorithm>
#include <set>
#include <map>
#include <ctime>
#include <random>
#include <climits>
#include <cmath>

using namespace std;

typedef long long ll;
typedef long double ld;

ld PI = std::acos((ld)-1);
const ll mod = 1e9 + 7;

ll powMod2(ll a, ll n, ll mod) {
    if (n == 0)
        return 1;
    if (n == 1)
        return a;
    ll d = powMod2(a, n / 2, mod);
    d = (d * d) % mod;
    if (n & 1)
        d = (d * a) % mod;
    return d;
}

ll powMod(ll a, ll n, ll mod) {
    if (a == 0)
        return 0;
    if (a == 1)
        return 1;
    return powMod2(a % mod, (n % (mod - 1) + mod - 1) % (mod - 1), mod);
}

struct intp {
    ll x;
    intp(ll a = 0) {
        x = (a % mod + mod) % mod;
    }
    intp operator+(intp& other) {
        return intp(x + other.x);
    }
    intp operator-(intp& other) {
        return intp(x - other.x);
    }
    intp operator*(intp& other) {
        return intp(x * other.x);
    }
    intp operator/(intp& other) {
        return intp(x * powMod(other.x, mod - 2, mod));
    }
};

const int x = 7000000;

void rotateL(std::vector<std::vector<int>>& m, int n) {
    std::vector<std::vector<int>> nm(2 * n - 1);
    for (int i = 0; i < 2 * n - 1; ++i) {
        int f = std::min(n + i - 1, 2 * n - 2);
        for (int j = 0; j < m[i].size(); ++j) {
            nm[f - j].push_back(m[i][j]);
        }
    }
    m = nm;
}

void rotateL3(std::vector<std::vector<int>>& m, int n) {

}
int main() {
    std::ios_base::sync_with_stdio(false);
    int n;
    std::cin >> n;
    std::vector<std::vector<int>> m(2 * n - 1);
    for (int i = 0;i < n; ++i) {
        m[i] = std::vector<int>(n + i, 0);
        for (int& j : m[i])
            std::cin >> j;
    }
    for (int i = n;i < 2 * n - 1; ++i) {
        m[i] = std::vector<int>(3 * n - 2 - i, 0);
        for (int& j : m[i])
            std::cin >> j;
    }

    std::string s;
    std::cin >> s;
    int cntT = 0, cntL = 0;
    for (char c : s) {
        if (c == 'T')
            cntT++;
        else {
            if (c == 'R') {
                if (cntT & 1)
                    cntL++;
                else
                    cntL--;
            }
            else {
                if (cntT & 1)
                    cntL--;
                else
                    cntL++;
            }
        }
    }

    
    cntL = (cntL % 6 + 6) % 6;
    for (int i = 0;i < cntL;++i) {
        rotateL(m, n);
    }
    if (cntT % 2 == 1) {
        for (auto& v : m) {
            std::reverse(v.begin(), v.end());
        }
    }
    for (auto& v : m) {
        for (int& i : v)
            std::cout << i << " ";
        std::cout << "\n";
    }

}

// ADGADGADGADGADGADGADGABC