﻿#include <iostream>
#include <string>
#include <vector>
#include <memory>

struct Hex {
    const int contur_n;
    std::vector<int> contur;
    int start_hex = 0;
    int step = 1;
    std::unique_ptr<Hex> intern_hex;
    Hex(const int ctr_n, std::vector<std::vector<int>> v) : contur_n(ctr_n) {
        const int total_n = (v.size() + 1) / 2;
        if (contur_n > 1) {
            contur.resize(6 * (contur_n - 1));
        }
        else {
            contur.resize(1);
            contur[0] = v[total_n - 1][total_n - 1];
            intern_hex = nullptr;
            return;
            // RETURN HERE
        }

        const int next_contur = contur_n - 1;
        for (int i = 0; i < contur_n; ++i) {
            contur[i] = v[total_n - contur_n][i + total_n - contur_n];
        }
        for (int i = contur_n; i < 3 * contur_n - 3; ++i) {
            const int k = (total_n - contur_n) + (i - contur_n + 1);
            contur[i] = v[k][v[k].size() - 1 - (total_n - contur_n)];
        }
        for (int i = contur_n * 3 - 3; i < 4 * contur_n - 3; ++i) {
            const int k = ((2 * total_n - 1) - 1) - (total_n - contur_n);

            contur[i] = v[k][v[k].size() - 1 - (total_n - contur_n) - (i - contur_n * 3 + 3)];
        }
        for (int i = 4 * contur_n - 3; i < 6 * contur_n - 6; ++i) {
            const int k = ((2 * total_n - 1) - 1) - (total_n - contur_n) + (4 * contur_n - 3 - 1 - i);
            contur[i] = v[k][total_n - contur_n];
        }
        intern_hex = std::make_unique<Hex>(next_contur, v);
    }
    void Left() {
        start_hex = (start_hex + step * (contur_n - 1) + 4 * contur.size()) % contur.size();
        if (contur_n > 1) {
            intern_hex->Left();
        }
    }
    void Right()
    {
        start_hex = (start_hex - step * (contur_n - 1) + 4 * contur.size()) % contur.size();
        if (contur_n > 1) {
            intern_hex->Right();
        }
    }
    void Transporate()
    {
        start_hex = (start_hex + step * (contur_n - 1) + contur.size() * 4) % contur.size();
        step = -step;
        if (contur_n > 1) {
            intern_hex->Transporate();
        }
    }
    void PrintLine(int line_idx)
    {
        if (line_idx == 0 || contur_n == 1) {
            for (int i = start_hex, k = 0; k < contur_n; i = (i + contur.size() + step) % contur.size(), ++k) {
                std::cout << contur[i] << " ";
            }
            return;
        }
        if (line_idx < 2 * contur_n - 1 - 1) {
            std::cout << contur[(contur.size() * 4 - step * line_idx + start_hex) % contur.size()] << " ";
            intern_hex->PrintLine(line_idx - 1);
            std::cout << contur[(step * (contur_n - 1 + line_idx) + start_hex + 5 * contur.size()) % contur.size()] << " ";
            return;
        }
        for (int i = (start_hex + step * (4 * contur_n - 4) + 5 * contur.size()) % contur.size(), k = 0; k < contur_n; i = (contur.size() + i - step) % contur.size(), ++k) {

            std::cout << contur[i] << " ";
        }
    }
    void Print()
    {
        for (int i = 0; i < 2 * contur_n - 1; ++i)
        {
            PrintLine(i);
            std::cout << '\n';
        }
    }
};
int CountLineSize(int n, int line_idx) {
    int m = (2 * n - 1) / 2;
    if (line_idx <= m) {
        return n + line_idx;
    }
    return n + ((2 * n - 1) - 1) - line_idx;
}
int main(int, char**) {
    int n;
    std::cin >> n;
    std::vector<std::vector<int>> v(2 * n - 1);
    int k;
    for (int i = 0; i < 2 * n - 1; ++i) {
        k = CountLineSize(n, i);
        v[i].resize(k);
        for (int j = 0; j < k; ++j) {
            std::cin >> v[i][j];
        }
    }
    Hex h(n, v);
    std::string str;
    std::cin >> str;
    for (int i = 0; i < str.size(); ++i) {

        if (str[i] == 'L') {
            h.Left();
        }
        else if (str[i] == 'R')
        {
            h.Right();
        }
        else if (str[i] == 'T')
        {
            h.Transporate();
        }
    }
    h.Print();

}
